/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.abilities.AbilityManager;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.messages.HelpStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.StatStrings;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.skills.SkillManager;
import xyz.nifeather.morph.updates.VersionHandling;

public class StatSubCommand
extends BrigadierCommand {
    @Resolved
    private MorphClientHandler clientHandler;
    @Resolved
    private SkillManager skillHandler;
    @Resolved
    private AbilityManager abilityHandler;
    @Resolved
    private MorphManager morphManager;

    @Override
    @NotNull
    public String name() {
        return "stat";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).executes(this::executes));
        super.registerAsChild(parentBuilder);
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.statDescription();
    }

    public int executes(CommandContext<CommandSourceStack> context) {
        FormattableMessage[] msg;
        int disguisesActive = this.morphManager.getActiveDisguises().stream().filter(s -> s.getPlayer().isOnline()).toArray().length;
        String authors = "MATRIX-feather";
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        StringBuilder listString = new StringBuilder();
        Collection<DisguiseBackend<?, ?>> backends = this.morphManager.listManagedBackends();
        String locale = MessageUtils.getLocale(sender);
        for (DisguiseBackend<?, ?> backend : backends) {
            Collection<?> instances = backend.listInstances();
            if (instances.isEmpty()) continue;
            FormattableMessage formattable = StatStrings.backendDescription();
            formattable.resolve("name", backend.getIdentifier()).resolve("count", "" + instances.size());
            String str = formattable.toString(locale);
            listString.append(str).append(" ");
        }
        if (listString.isEmpty()) {
            listString.append(StatStrings.backendsNone().toString(locale));
        }
        DisguiseBackend<?, ?> defaultBackend = this.morphManager.getDefaultBackend();
        String defaultBackendString = "%s (%s)".formatted(defaultBackend.getIdentifier(), defaultBackend.getClass().getName());
        String versionString = this.plugin.getPluginMeta().getVersion();
        for (FormattableMessage formattableMessage : msg = new FormattableMessage[]{StatStrings.versionString().resolve("version", "%s(%s)".formatted(versionString, VersionHandling.toVersionInfo(versionString))).resolve("author", authors).resolve("proto", String.valueOf(this.clientHandler.targetApiVersion)), StatStrings.defaultBackendString().resolve("backend", defaultBackendString), StatStrings.activeDataStoreString().resolve("store", this.morphManager.getDataStore().getClass().getName()), StatStrings.activeBackends().resolve("list", listString.toString()), StatStrings.providersString().resolve("count", String.valueOf(MorphManager.getProviders().size())), StatStrings.bannedDisguisesString().resolve("count", String.valueOf(this.morphManager.getBannedDisguises().size())), StatStrings.abilitiesString().resolve("count", String.valueOf(this.abilityHandler.getRegistedAbilities().size())), StatStrings.skillsString().resolve("count", String.valueOf(this.skillHandler.getRegistedSkills().size())), StatStrings.activeClientsString().resolve("count", String.valueOf(this.clientHandler.getConnectedPlayers().size())), StatStrings.activeDisguisesString().resolve("count", String.valueOf(disguisesActive)).resolve("max", String.valueOf(this.featherMorph().getPlatform().onlinePlayersNative().size()))}) {
            sender.sendMessage(MessageUtils.prefixes(sender, formattableMessage));
        }
        return 1;
    }

    private FormattableMessage getFormattable(String str) {
        return new FormattableMessage(this.plugin, str);
    }

    @Override
    public String getPermissionRequirement() {
        return "feathermorph.stat";
    }
}

