/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.config;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.messages.CommonStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.BindableList;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigNode;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.PluginConfigManager;
import xyz.nifeather.morph.shaded.pluginbase.Managers.DependencyManager;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;

public class MorphConfigManager
extends PluginConfigManager {
    private static MorphConfigManager instance;
    private Map<String, BindableList<?>> bindableLists;

    public MorphConfigManager(FeatherMorphMain plugin) {
        super(plugin);
        instance = this;
    }

    public static MorphConfigManager getInstance() {
        return instance;
    }

    public <T> T getOrDefault(Class<T> type, ConfigOption option) {
        T val = this.get(type, option);
        if (val == null) {
            this.set(option, option.defaultValue);
            return (T)option.defaultValue;
        }
        return val;
    }

    public <T> T getOrDefault(Class<T> type, ConfigOption option, @Nullable T defaultValue) {
        T val = this.get(type, option);
        if (val == null) {
            this.set(option, defaultValue);
            return defaultValue;
        }
        return val;
    }

    @Override
    @NotNull
    public Map<ConfigNode, Object> getAllNotDefault() {
        ConfigOption[] options = ConfigOption.values();
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ConfigOption o : options) {
            Object val = this.getOrDefault(o.defaultValue.getClass(), o);
            if (val.equals(o.defaultValue)) continue;
            map.put((Object)o.node, val);
        }
        return map;
    }

    public <T> BindableList<T> getBindableList(Class<T> clazz, ConfigOption option) {
        this.ensureBindableListNotNull();
        BindableList val = this.bindableLists.getOrDefault(option.toString(), null);
        if (val != null) {
            return val;
        }
        List originalList = this.backendConfig.getList(option.toString(), new ArrayList());
        originalList.removeIf(listVal -> !clazz.isInstance(listVal));
        BindableList list = new BindableList();
        list.addAll(originalList);
        list.onListChanged((diffList, reason) -> {
            this.backendConfig.set(option.toString(), new ArrayList(list));
            this.save();
        }, true);
        this.bindableLists.put(option.toString(), list);
        return list;
    }

    public <T> Bindable<T> getBindable(Class<T> type, ConfigOption option) {
        if (type.isInstance(option.defaultValue)) {
            return this.getBindable(type, option, option.defaultValue);
        }
        throw new IllegalArgumentException(String.valueOf((Object)option) + "\u7684\u7c7b\u578b\u548c" + String.valueOf(type) + "\u4e0d\u517c\u5bb9");
    }

    public <T> void bind(Bindable<T> bindable, ConfigOption option) {
        Bindable<?> bb = this.getBindable(option.defaultValue.getClass(), option);
        if (!bindable.getClass().isInstance(bb)) {
            throw new IllegalArgumentException("\u5c1d\u8bd5\u5c06\u4e00\u4e2aBindable\u7ed1\u5b9a\u5728\u4e0d\u517c\u5bb9\u7684\u914d\u7f6e(" + String.valueOf((Object)option) + ")\u4e0a");
        }
        bindable.bindTo(bb);
    }

    public <T> void bind(Class<T> clazz, BindableList<T> bindable, ConfigOption option) {
        BindableList<T> bb = this.getBindableList(clazz, option);
        if (!bindable.getClass().isInstance(bb)) {
            throw new IllegalArgumentException("\u5c1d\u8bd5\u5c06\u4e00\u4e2aBindable\u7ed1\u5b9a\u5728\u4e0d\u517c\u5bb9\u7684\u914d\u7f6e(" + String.valueOf((Object)option) + ")\u4e0a");
        }
        bindable.bindTo(bb);
    }

    public <T> Bindable<T> getBindable(Class<T> type, ConfigOption path, T defaultValue) {
        return super.getBindable(type, path.node, defaultValue);
    }

    private void ensureBindableListNotNull() {
        if (this.bindableLists == null) {
            this.bindableLists = new Object2ObjectOpenHashMap();
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.ensureBindableListNotNull();
        this.bindableLists.forEach((node, list) -> {
            List configList = this.backendConfig.getList(node);
            if (configList == null) {
                return;
            }
            list.clear();
            list.addAllInternal(configList);
        });
        int targetVersion = 44;
        Integer configVersion = this.getOrDefault(Integer.class, ConfigOption.VERSION);
        if (configVersion < targetVersion) {
            FeatherMorphMain.getInstance().getSLF4JLogger().info("Migrating config from %s to %s".formatted(configVersion, targetVersion));
            Map<ConfigNode, Object> nonDefaults = this.getAllNotDefault();
            this.plugin.saveResource("config.yml", true);
            this.plugin.reloadConfig();
            FileConfiguration newConfig = this.plugin.getConfig();
            nonDefaults.forEach((n, v) -> {
                ConfigOption matching = Arrays.stream(ConfigOption.values()).filter(option -> option.node.toString().equals(n.toString())).findFirst().orElse(null);
                if (matching == null) {
                    return;
                }
                if (v instanceof Collection) {
                    Collection collection = (Collection)v;
                    Collection defaultVal = null;
                    Object patt0$temp = matching.defaultValue;
                    if (patt0$temp instanceof Collection) {
                        Collection c1;
                        defaultVal = c1 = (Collection)patt0$temp;
                    }
                    if (defaultVal != null) {
                        defaultVal.forEach(c -> {
                            if (!collection.contains(c)) {
                                collection.add(c);
                            }
                        });
                    }
                    newConfig.set(n.toString(), v);
                } else {
                    newConfig.set(n.toString(), v);
                }
            });
            if (configVersion < 1) {
                String locale = Locale.getDefault().toLanguageTag().replace('-', '_').toLowerCase();
                newConfig.set(ConfigOption.LANGUAGE_CODE.toString(), (Object)locale);
            }
            if (configVersion < 15) {
                String oldSkillItem = this.get(String.class, ConfigOption.ACTION_ITEM);
                this.remove(ConfigOption.ACTION_ITEM);
                if (oldSkillItem != null) {
                    newConfig.set(ConfigOption.SKILL_ITEM.toString(), (Object)oldSkillItem);
                }
            }
            if (configVersion < 21) {
                boolean requireCache;
                DependencyManager depMgr = DependencyManager.getInstance(this.plugin.getNamespace());
                MessageStore messageStore = depMgr.get(MessageStore.class);
                boolean bl = requireCache = depMgr.get(this.getClass(), false) == null;
                if (requireCache) {
                    depMgr.cache(this);
                }
                String msg = messageStore.get(CommonStrings.chatOverrideDefaultPattern().getKey(), (String)ConfigOption.CHAT_OVERRIDE_DEFAULT_PATTERN.defaultValue, MessageUtils.getServerLocale());
                newConfig.set(ConfigOption.CHAT_OVERRIDE_DEFAULT_PATTERN.toString(), (Object)msg);
                String pluginPrefix = messageStore.get(CommonStrings.pluginMessageString().getKey(), (String)ConfigOption.PLUGIN_PREFIX.defaultValue, MessageUtils.getServerLocale());
                newConfig.set(ConfigOption.PLUGIN_PREFIX.toString(), (Object)pluginPrefix);
                if (requireCache) {
                    depMgr.unCache(this);
                }
            }
            if (configVersion < 23) {
                Boolean val = this.get(Boolean.class, ConfigOption.MODIFY_BOUNDING_BOX_LEGACY);
                this.remove(ConfigOption.MODIFY_BOUNDING_BOX_LEGACY);
                if (val != null) {
                    newConfig.set(ConfigOption.MODIFY_BOUNDING_BOX.toString(), (Object)val);
                }
            }
            if (configVersion < 34) {
                Boolean noFlyInLiquid = this.getOrDefault(Boolean.class, ConfigOption.FLYABILITY_NO_LIQUID, null);
                this.remove(ConfigOption.FLYABILITY_NO_LIQUID);
                if (noFlyInLiquid != null && noFlyInLiquid.booleanValue()) {
                    List<String> list2 = Bukkit.getWorlds().stream().map(WorldInfo::getName).toList();
                    newConfig.set(ConfigOption.FLYABILITY_DISALLOW_FLY_IN_WATER.toString(), list2);
                    newConfig.set(ConfigOption.FLYABILITY_DISALLOW_FLY_IN_LAVA.toString(), list2);
                }
            }
            if (configVersion < 37) {
                this.remove(ConfigOption.SKILL_ITEM);
            }
            if (configVersion < 40) {
                this.remove(ConfigOption.SR_SHOW_PLAYER_DISGUISES_IN_TAB);
                this.remove(ConfigOption.HIDE_DISGUISED_PLAYERS_IN_TAB);
            }
            if (configVersion < 41) {
                this.remove(ConfigOption.ENABLE_SENTRY_LOGGER);
            }
            if (configVersion < 44) {
                this.remove(ConfigOption.BLACKLIST_PATTERNS);
                this.remove(ConfigOption.BLACKLIST_TAGS);
            }
            newConfig.set(ConfigOption.VERSION.toString(), (Object)targetVersion);
            if (((String)newConfig.get(ConfigOption.MASTER_SECRET.toString(), (Object)"~UNSET")).equalsIgnoreCase("~UNSET")) {
                String defVal = ConfigOption.MASTER_SECRET.defaultValue.toString();
                this.getBindable(String.class, ConfigOption.MASTER_SECRET).set(defVal);
                newConfig.set(ConfigOption.MASTER_SECRET.toString(), (Object)defVal);
            }
            this.plugin.saveConfig();
            this.reload();
        }
    }

    public void remove(ConfigOption option) {
        this.set(option, null);
        this.backendConfig.set(option.node.toString(), null);
    }

    public <T> T get(Class<T> type, ConfigOption option) {
        return this.get(type, option.node);
    }

    public void set(ConfigOption option, Object val) {
        this.set(option.node, val);
    }
}

