/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.messages;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.CapeStrings;
import xyz.nifeather.morph.messages.CommandNameStrings;
import xyz.nifeather.morph.messages.CommandStrings;
import xyz.nifeather.morph.messages.CommonStrings;
import xyz.nifeather.morph.messages.ExceptionStrings;
import xyz.nifeather.morph.messages.HelpStrings;
import xyz.nifeather.morph.messages.HintStrings;
import xyz.nifeather.morph.messages.MorphMessageSubStore;
import xyz.nifeather.morph.messages.MorphStrings;
import xyz.nifeather.morph.messages.RequestStrings;
import xyz.nifeather.morph.messages.SkillStrings;
import xyz.nifeather.morph.messages.SkinCacheStrings;
import xyz.nifeather.morph.messages.StatStrings;
import xyz.nifeather.morph.messages.TypesString;
import xyz.nifeather.morph.messages.UpdateStrings;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Messages.IStrings;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;

public class MorphMessageStore
extends MessageStore<FeatherMorphMain> {
    private final List<Class<? extends IStrings>> strings = ObjectList.of((Object[])new Class[]{CommonStrings.class, CommandStrings.class, HelpStrings.class, MorphStrings.class, RequestStrings.class, SkillStrings.class, CommandNameStrings.class, HintStrings.class, TypesString.class, StatStrings.class, UpdateStrings.class, SkinCacheStrings.class, CapeStrings.class, ExceptionStrings.class});
    private final Map<String, MorphMessageSubStore> subStores = new Object2ObjectOpenHashMap();
    private final Bindable<String> serverLanguage = new Bindable();
    private boolean oWNonDef;

    public File getFile(String relativePath, boolean nullIfNotFound) {
        if (relativePath == null || relativePath.isBlank()) {
            return null;
        }
        URI dataFolder = this.plugin.getDataFolder().toURI();
        File file = new File(URI.create(String.valueOf(dataFolder) + "/" + relativePath));
        if (!nullIfNotFound) {
            return file;
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Nullable
    public String getAbsolutePath(String relativePath) {
        if (relativePath == null || relativePath.isBlank()) {
            return null;
        }
        return this.plugin.getDataFolder().toURI().getPath() + "/" + relativePath;
    }

    @Initializer
    private void load(MorphConfigManager config) {
        File legacyDefaultFile = this.getFile("messages/default.json", true);
        if (legacyDefaultFile != null) {
            File targetFile = this.getFile(this.getFileName(), false);
            if (targetFile.exists()) {
                targetFile.delete();
            }
            try {
                Files.move(legacyDefaultFile.toPath(), targetFile.toPath(), new CopyOption[0]);
                this.addSchedule(() -> super.reloadConfiguration());
            }
            catch (IOException e) {
                this.logger.error("Unable to update builtin message store", (Throwable)e);
            }
        }
        config.bind(this.serverLanguage, ConfigOption.LANGUAGE_CODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MorphMessageSubStore getOrCreateSubStore(String locale) {
        MorphMessageSubStore store;
        Map<String, MorphMessageSubStore> map = this.subStores;
        synchronized (map) {
            store = this.subStores.getOrDefault(locale, null);
            if (store != null) {
                return store;
            }
            store = new MorphMessageSubStore(locale, this.strings, this);
            store.initializeStorage();
            store.saveConfiguration();
            this.subStores.put(locale, store);
        }
        return store;
    }

    public Map<String, String> getAllMessages() {
        return (Map)this.storingObject;
    }

    @Override
    @NotNull
    protected String getFileName() {
        return "messages/template.json";
    }

    @Override
    @NotNull
    protected Map<String, String> createDefault() {
        return new ConcurrentHashMap<String, String>();
    }

    @Override
    public String get(String key, @Nullable String defaultValue, @Nullable String locale) {
        String serverLanguage = this.serverLanguage.get();
        if (locale == null || locale.isBlank() || locale.isEmpty()) {
            this.logger.warn("Resolving message key " + key + " for null or empty locale");
            locale = serverLanguage;
        }
        ObjectArrayList messageStores = ObjectArrayList.of((Object[])new MorphMessageSubStore[]{this.getOrCreateSubStore("override"), this.getOrCreateSubStore(locale)});
        if (!locale.equals(serverLanguage)) {
            messageStores.add((Object)this.getOrCreateSubStore(serverLanguage));
        }
        messageStores.add((Object)this.getOrCreateSubStore("en_us"));
        for (MorphMessageSubStore store : messageStores) {
            String msg = store.get(key, "NIL", null);
            if (msg.equals("NIL")) {
                msg = null;
            }
            if (msg == null) continue;
            return msg;
        }
        return defaultValue == null ? "%s@%s".formatted(key, locale) : defaultValue;
    }

    public boolean reloadOverwriteNonDefault() {
        this.oWNonDef = true;
        return this.reloadConfiguration();
    }

    @Override
    public boolean reloadConfiguration() {
        AtomicBoolean allSuccess = new AtomicBoolean(true);
        this.subStores.forEach((l, s) -> {
            if (this.oWNonDef) {
                s.overWriteNonDefaultAfterReload();
            }
            if (!s.reloadConfiguration()) {
                allSuccess.set(false);
            }
        });
        this.oWNonDef = false;
        return super.reloadConfiguration() && allSuccess.get();
    }

    @Override
    protected List<Class<? extends IStrings>> getStrings() {
        return this.strings;
    }

    @Override
    protected String getPluginNamespace() {
        return FeatherMorphMain.getMorphNameSpace();
    }
}

