/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.utilities.DisguiseUtils;
import xyz.nifeather.morph.utilities.ItemUtils;

public class DisguiseEquipment
implements EntityEquipment {
    private final ItemStack[] itemStacks = new ItemStack[EquipmentSlot.values().length];
    private final Map<EquipmentSlot, ItemStack> dirtyStacks = new Object2ObjectOpenHashMap();
    public boolean allowNull = false;

    public Map<EquipmentSlot, ItemStack> getDirty() {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(this.dirtyStacks);
        this.dirtyStacks.clear();
        return map;
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        this.itemStacks[slot.ordinal()] = item;
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item, boolean silent) {
        this.setItem(slot, item);
    }

    public void setHandItems(ItemStack ... stacks) {
        if (stacks == null) {
            this.setItemInHand(null);
            this.setItemInOffHand(null);
            return;
        }
        this.setItemInMainHand(stacks.length >= 1 ? stacks[0] : null);
        this.setItemInOffHand(stacks.length >= 2 ? stacks[1] : null);
    }

    @NotNull
    public ItemStack getItem(@NotNull EquipmentSlot slot) {
        return this.allowNull ? this.itemStacks[slot.ordinal()] : DisguiseUtils.itemOrAir(this.itemStacks[slot.ordinal()]);
    }

    @NotNull
    public ItemStack getItemInMainHand() {
        return this.getItem(EquipmentSlot.HAND);
    }

    public void setItemInMainHand(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.HAND, item);
    }

    public void setItemInMainHand(@Nullable ItemStack item, boolean silent) {
        this.setItemInHand(item);
    }

    @NotNull
    public ItemStack getItemInOffHand() {
        return this.getItem(EquipmentSlot.OFF_HAND);
    }

    public void setItemInOffHand(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.OFF_HAND, item);
    }

    public void setItemInOffHand(@Nullable ItemStack item, boolean silent) {
        this.setItemInOffHand(item);
    }

    @NotNull
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(@Nullable ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public ItemStack getHelmet() {
        return this.getItem(EquipmentSlot.HEAD);
    }

    public void setHelmet(@Nullable ItemStack helmet) {
        this.setItem(EquipmentSlot.HEAD, helmet);
    }

    public void setHelmet(@Nullable ItemStack helmet, boolean silent) {
        this.setHelmet(helmet);
    }

    public ItemStack getChestplate() {
        return this.getItem(EquipmentSlot.CHEST);
    }

    public void setChestplate(@Nullable ItemStack chestplate) {
        this.setItem(EquipmentSlot.CHEST, chestplate);
    }

    public void setChestplate(@Nullable ItemStack chestplate, boolean silent) {
        this.setChestplate(chestplate);
    }

    public ItemStack getLeggings() {
        return this.getItem(EquipmentSlot.LEGS);
    }

    public void setLeggings(@Nullable ItemStack leggings) {
        this.setItem(EquipmentSlot.LEGS, leggings);
    }

    public void setLeggings(@Nullable ItemStack leggings, boolean silent) {
        this.setLeggings(leggings);
    }

    public ItemStack getBoots() {
        return this.getItem(EquipmentSlot.FEET);
    }

    public void setBoots(@Nullable ItemStack boots) {
        this.setItem(EquipmentSlot.FEET, boots);
    }

    public void setBoots(@Nullable ItemStack boots, boolean silent) {
        this.setBoots(boots);
    }

    public ItemStack @NotNull [] getArmorContents() {
        return new ItemStack[]{this.getBoots(), this.getLeggings(), this.getChestplate(), this.getHelmet()};
    }

    public void setArmorContents(@NotNull ItemStack[] items) {
        ItemStack air = ItemUtils.itemOrAir(null);
        this.setBoots(items.length >= 1 ? items[0] : air);
        this.setLeggings(items.length >= 2 ? items[1] : air);
        this.setChestplate(items.length >= 3 ? items[2] : air);
        this.setHelmet(items.length >= 4 ? items[3] : air);
    }

    public ItemStack @NotNull [] getHandItems() {
        return new ItemStack[]{this.getItemInMainHand(), this.getItemInOffHand()};
    }

    public void clear() {
        Arrays.fill(this.itemStacks, null);
    }

    public float getItemInHandDropChance() {
        return 0.0f;
    }

    public void setItemInHandDropChance(float chance) {
    }

    public float getItemInMainHandDropChance() {
        return 0.0f;
    }

    public void setItemInMainHandDropChance(float chance) {
    }

    public float getItemInOffHandDropChance() {
        return 0.0f;
    }

    public void setItemInOffHandDropChance(float chance) {
    }

    public float getHelmetDropChance() {
        return 0.0f;
    }

    public void setHelmetDropChance(float chance) {
    }

    public float getChestplateDropChance() {
        return 0.0f;
    }

    public void setChestplateDropChance(float chance) {
    }

    public float getLeggingsDropChance() {
        return 0.0f;
    }

    public void setLeggingsDropChance(float chance) {
    }

    public float getBootsDropChance() {
        return 0.0f;
    }

    public void setBootsDropChance(float chance) {
    }

    @NotNull
    public Entity getHolder() {
        throw new NotImplementedException("no");
    }

    public float getDropChance(@NotNull EquipmentSlot slot) {
        return 0.0f;
    }

    public void setDropChance(@NotNull EquipmentSlot slot, float chance) {
    }

    public static class EmptyDisguiseEquipment
    extends DisguiseEquipment {
    }
}

