/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandle;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandle;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;

public class SingleProperty<T> {
    private final String identifier;
    private final T defaultVal;
    private final Class<T> type;
    private final InputHandle<T> inputHandle;
    private final OutputHandle<T> outputHandle;
    private final boolean hideFromUserInput;
    private final List<String> validValues = new CopyOnWriteArrayList<String>();
    private final List<T> randomValues = new CopyOnWriteArrayList<T>();

    public String id() {
        return this.identifier;
    }

    public T defaultVal() {
        return this.defaultVal;
    }

    public Class<T> type() {
        return this.type;
    }

    public boolean hideFromUserInput() {
        return this.hideFromUserInput;
    }

    public Optional<T> forInput(String input) throws ParseErrorException {
        return this.inputHandle.handle(this.id(), input);
    }

    @NotNull
    public String forValue(T value) throws ParseErrorException {
        return this.outputHandle.handle(this.id(), value);
    }

    public SingleProperty(String identifier, T defaultValue, Class<T> type, @NotNull InputHandle<T> inputHandle, @NotNull OutputHandle<T> outputHandle, boolean hideFromUserInput) {
        this.identifier = identifier;
        this.defaultVal = defaultValue;
        this.type = type;
        this.inputHandle = inputHandle;
        this.outputHandle = outputHandle;
        this.hideFromUserInput = hideFromUserInput;
    }

    public @Unmodifiable List<String> validInputs() {
        return new ObjectArrayList(this.validValues);
    }

    public SingleProperty<T> withValidInput(Collection<String> input) {
        this.validValues.addAll(input);
        return this;
    }

    public SingleProperty<T> withValidInput(String ... input) {
        this.validValues.addAll(Arrays.stream(input).toList());
        return this;
    }

    public @Unmodifiable List<T> getRandomValues() {
        return new ObjectArrayList(this.randomValues);
    }

    public SingleProperty<T> withRandom(Collection<T> values) {
        this.randomValues.clear();
        this.randomValues.addAll(values);
        return this;
    }

    public SingleProperty<T> withRandom(T ... randomValues) {
        return this.withRandom((Collection<T>)Arrays.stream(randomValues).toList());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SingleProperty)) {
            return false;
        }
        SingleProperty other = (SingleProperty)obj;
        return this.identifier.equals(other.identifier) && this.type.equals(other.type);
    }

    public static <T> SingleProperty<T> of(String id, T val, InputHandle<T> inputHandle, OutputHandle<T> outputHandle) {
        return new SingleProperty<T>(id, val, val.getClass(), inputHandle, outputHandle, false);
    }

    public static <T> SingleProperty<T> of(String id, T val, InputHandle<T> inputHandle, OutputHandle<T> outputHandle, boolean hideFromUserInput) {
        return new SingleProperty<T>(id, val, val.getClass(), inputHandle, outputHandle, hideFromUserInput);
    }
}

