/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.papermc.paper.math.Rotations;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;

public class ArmorStandProperties
extends BaseLivingEntityProperties<ArmorStand> {
    public final SingleProperty<Boolean> SHOW_ARMS = this.createProperty("armor_stand/show_arms", false, InputHandles::readBooleanRelaxed, OutputHandles::writeBoolean).withValidInput("true", "false");
    public final SingleProperty<Boolean> HAS_BASE_PLATE = this.createProperty("armor_stand/has_base_plate", true, InputHandles::readBooleanRelaxed, OutputHandles::writeBoolean).withValidInput("true", "false");
    public final SingleProperty<Boolean> SMALL = this.createProperty("armor_stand/small", false, InputHandles::readBooleanRelaxed, OutputHandles::writeBoolean).withValidInput("true", "false");
    public final SingleProperty<Rotations> HEAD_ROTATION = this.createProperty("armor_stand/head_rotation", Rotations.ZERO, InputHandles::readRotations, OutputHandles::writeRotations);
    public final SingleProperty<Rotations> BODY_ROTATION = this.createProperty("armor_stand/body_rotation", Rotations.ZERO, InputHandles::readRotations, OutputHandles::writeRotations);
    public final SingleProperty<Rotations> RIGHT_ARM_ROTATION = this.createProperty("armor_stand/right_arm_rotation", Rotations.ZERO, InputHandles::readRotations, OutputHandles::writeRotations);
    public final SingleProperty<Rotations> LEFT_ARM_ROTATION = this.createProperty("armor_stand/left_arm_rotation", Rotations.ZERO, InputHandles::readRotations, OutputHandles::writeRotations);
    public final SingleProperty<Rotations> RIGHT_LEG_ROTATION = this.createProperty("armor_stand/right_leg_rotation", Rotations.ZERO, InputHandles::readRotations, OutputHandles::writeRotations);
    public final SingleProperty<Rotations> LEFT_LEG_ROTATION = this.createProperty("armor_stand/left_leg_rotation", Rotations.ZERO, InputHandles::readRotations, OutputHandles::writeRotations);
    @Nullable
    private volatile MorphConfigManager config;
    private final Bindable<Boolean> showArms = new Bindable<Boolean>(false);
    private final Gson gson = new GsonBuilder().create();

    private void lateInitConfig() {
        if (this.config != null) {
            return;
        }
        FeatherMorphAPI api = FeatherMorphAPI.instance();
        if (api == null) {
            return;
        }
        MorphConfigManager configManager = api.directAccess().getGlobalDependency(MorphConfigManager.class, false);
        if (configManager == null) {
            return;
        }
        configManager.bind(this.showArms, ConfigOption.ARMORSTAND_SHOW_ARMS);
        this.config = configManager;
    }

    public ArmorStandProperties() {
        this.registerSingle(this.SHOW_ARMS, this.HAS_BASE_PLATE, this.SMALL);
        this.registerSingle(this.HEAD_ROTATION, this.BODY_ROTATION, this.RIGHT_ARM_ROTATION, this.LEFT_ARM_ROTATION, this.RIGHT_LEG_ROTATION, this.LEFT_LEG_ROTATION);
    }

    @Override
    @Nullable
    protected ArmorStand tryCastEntity(@Nullable Entity targetEntity) {
        ArmorStand armorStand;
        return targetEntity instanceof ArmorStand ? (armorStand = (ArmorStand)targetEntity) : null;
    }

    @Override
    public void setupPropertiesFromEntity(PropertyHandler propertyHandler, @NotNull ArmorStand armorStand) {
        propertyHandler.set(this.SHOW_ARMS, armorStand.hasArms());
        propertyHandler.set(this.HAS_BASE_PLATE, armorStand.hasBasePlate());
        propertyHandler.set(this.SMALL, armorStand.isSmall());
        propertyHandler.set(this.HEAD_ROTATION, armorStand.getHeadRotations());
        propertyHandler.set(this.BODY_ROTATION, armorStand.getBodyRotations());
        propertyHandler.set(this.LEFT_ARM_ROTATION, armorStand.getLeftArmRotations());
        propertyHandler.set(this.RIGHT_ARM_ROTATION, armorStand.getRightArmRotations());
        propertyHandler.set(this.LEFT_LEG_ROTATION, armorStand.getLeftLegRotations());
        propertyHandler.set(this.RIGHT_LEG_ROTATION, armorStand.getRightLegRotations());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        this.lateInitConfig();
        propertyHandler.set(this.SHOW_ARMS, this.showArms.get());
    }

    private String rotationToStringArray(Rotations vec) {
        float[] array = new float[]{(float)vec.x(), (float)vec.y(), (float)vec.z()};
        return this.gson.toJson((Object)array);
    }
}

