/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.AbstractProperties;

public abstract class BaseLivingEntityProperties<E extends Entity>
extends AbstractProperties<E> {
    public final SingleProperty<Boolean> CUSTOM_NAME_VISIBLE = this.createProperty("entity/custom_name_visible", false, InputHandles::readBooleanRelaxed, OutputHandles::writeBoolean).withValidInput("true", "false");
    public final SingleProperty<Integer> STUCKED_ARROWS = this.createProperty("entity/stucked_arrows", 0, this::readArrows, OutputHandles::writeInteger);
    public final SingleProperty<Component> CUSTOM_NAME = this.createCustomNameProperty();
    public final SingleProperty<DisguiseEquipment> EQUIPMENT = SingleProperty.of("entity/equipment", new DisguiseEquipment(), InputHandles::reservedException, OutputHandles::writeEquipment, true);
    public final SingleProperty<Boolean> DISPLAY_DISGUISE_EQUIPMENT = SingleProperty.of("entity/display_disguise_equipment", false, InputHandles::reservedException, OutputHandles::writeBoolean, true);
    private static final Component minimessageFormatFail = Component.text((String)"MiniMessage format error");
    private static final Component minimessageCastFail = Component.text((String)"MiniMessage cast error");

    protected SingleProperty<Component> createCustomNameProperty() {
        return this.createProperty("entity/custom_name", Component.empty(), InputHandles::readAdventureComponentLimitedNonEmpty, OutputHandles::writeAdventureComponentJSON);
    }

    @Override
    protected void setupPropertiesFromEntity(PropertyHandler propertyHandler, @NotNull E targetEntity) {
        propertyHandler.set(this.CUSTOM_NAME_VISIBLE, targetEntity.isCustomNameVisible());
        Component entityCustomName = targetEntity.customName();
        if (entityCustomName != null) {
            propertyHandler.set(this.CUSTOM_NAME, entityCustomName);
        }
    }

    private Optional<Integer> readArrows(String propertyName, String string) throws ParseErrorException {
        Integer val = InputHandles.readInteger(propertyName, string).orElseThrow(() -> new ParseErrorException(propertyName, "readArrows: Unable to parse arrows"));
        InputHandles.throwIfOutOfBounds(propertyName, val, 0, 100);
        return Optional.of(val);
    }

    public BaseLivingEntityProperties() {
        this.registerSingle(this.CUSTOM_NAME, this.CUSTOM_NAME_VISIBLE, this.STUCKED_ARROWS, this.EQUIPMENT, this.DISPLAY_DISGUISE_EQUIPMENT);
    }
}

