/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import com.mojang.authlib.GameProfile;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mannequin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.GameProfileUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class MannequinProperties
extends BaseLivingEntityProperties<Mannequin> {
    public final SingleProperty<Component> NPC_DESCRIPTION = this.createProperty("mannequin/description", Component.empty(), InputHandles::readAdventureComponentLimited, OutputHandles::writeAdventureComponentJSON);
    public final SingleProperty<Boolean> HIDE_DESCRIPTION = this.createProperty("mannequin/hide_description", false, InputHandles::readBooleanRelaxed, OutputHandles::writeBoolean);
    public final SingleProperty<Boolean> IMMOVABLE = SingleProperty.of("mannequin/immovable", false, InputHandles::reservedException, OutputHandles::writeBoolean, false).withValidInput("true", "false");
    public final SingleProperty<ResolvableProfile> SKIN_INTERNAL = SingleProperty.of("mannequin/skin_internal", GameProfileUtils.asResolvableProfile(new GameProfile(Uuids.NIL_UUID, "unknown")), InputHandles::reservedException, OutputHandles::writeResolvableProfileAny, true);
    public final SingleProperty<String> SKIN_NAME = this.createProperty("mannequin/skin", "Notch", InputHandles::readSkinName, OutputHandles::writeString);

    public MannequinProperties() {
        this.registerSingle(this.NPC_DESCRIPTION, this.HIDE_DESCRIPTION, this.SKIN_INTERNAL, this.SKIN_NAME, this.IMMOVABLE);
    }

    @Override
    @Nullable
    protected Mannequin tryCastEntity(@Nullable Entity targetEntity) {
        Mannequin mannequin;
        return targetEntity instanceof Mannequin ? (mannequin = (Mannequin)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(PropertyHandler propertyHandler, @NotNull Mannequin targetEntity) {
        propertyHandler.set(this.SKIN_INTERNAL, targetEntity.getProfile());
        Component description = targetEntity.getDescription();
        if (description != null) {
            propertyHandler.set(this.NPC_DESCRIPTION, description);
        }
        propertyHandler.set(this.IMMOVABLE, targetEntity.isImmovable());
        super.setupPropertiesFromEntity(propertyHandler, targetEntity);
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.CUSTOM_NAME_VISIBLE, true);
    }
}

