/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.gui;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.skins.PlayerSkinProvider;

public class IconLookup {
    private static IconLookup instance;
    private final Map<String, ItemStack> registry = new ConcurrentHashMap<String, ItemStack>();
    private final ItemStack defaultItem = this.generateDefaultItem();

    public static IconLookup instance() {
        if (instance == null) {
            instance = new IconLookup();
        }
        return instance;
    }

    public IconLookup() {
        this.init();
    }

    protected Material getDisplayBaseMaterial() {
        return Material.SNOWBALL;
    }

    protected ItemStack generateDefaultItem() {
        ItemStack item = ItemStack.of((Material)this.getDisplayBaseMaterial());
        item.setData(DataComponentTypes.ITEM_MODEL, (Object)NamespacedKey.minecraft((String)"bedrock"));
        return item;
    }

    private void init() {
        for (EntityType value : EntityType.values()) {
            if (value == EntityType.PLAYER || value == EntityType.UNKNOWN || !value.isAlive()) continue;
            this.register(value);
        }
        this.register(EntityType.ARMOR_STAND, this.createIconForType(Material.ARMOR_STAND));
        this.register(EntityType.GIANT, this.createIconForType(Material.ZOMBIE_HEAD));
        this.register(EntityType.ILLUSIONER, this.createIconForType(Material.SPECTRAL_ARROW));
        this.register(EntityType.MANNEQUIN, this.createIconForType(Material.PLAYER_HEAD));
    }

    public ItemStack createIconForType(Material targetModelMaterial) {
        ItemStack materialItem = ItemStack.of((Material)targetModelMaterial);
        Key model = (Key)materialItem.getData(DataComponentTypes.ITEM_MODEL);
        Object modelKey = model == null ? targetModelMaterial.getKey() : model.key();
        ItemStack targetItem = ItemStack.of((Material)this.getDisplayBaseMaterial());
        targetItem.setData(DataComponentTypes.ITEM_MODEL, modelKey);
        return targetItem;
    }

    public ItemStack createIconForPlayer(String playerName) {
        ItemStack stack = this.createIconForType(Material.PLAYER_HEAD);
        stack.setData(DataComponentTypes.RARITY, (Object)ItemRarity.COMMON);
        PlayerSkinProvider.getInstance().fetchSkin(playerName).thenAccept(optional -> {
            if (optional.isEmpty()) {
                return;
            }
            stack.setData(DataComponentTypes.PROFILE, (Object)ResolvableProfile.resolvableProfile((PlayerProfile)new CraftPlayerProfile((GameProfile)optional.get())));
        });
        return stack;
    }

    private ItemStack createIconForEntityType(EntityType type) {
        String name = "%s_SPAWN_EGG".formatted(type.name().toUpperCase());
        Material match = Material.matchMaterial((String)name);
        if (match == null) {
            return this.defaultItem;
        }
        return this.createIconForType(match);
    }

    private void register(EntityType type) {
        this.register(type, this.createIconForEntityType(type));
    }

    private void register(EntityType type, ItemStack item) {
        item.editMeta(meta -> meta.setRarity(ItemRarity.COMMON));
        this.register(type.key().asString(), item);
    }

    private void register(EntityType type, Material material) {
        this.register(type, this.createIconForType(material));
    }

    private void register(String disguiseIdentifier, ItemStack stack) {
        this.registry.put(disguiseIdentifier, stack);
    }

    public ItemStack lookup(String disguiseIdentifier) {
        ItemStack item = disguiseIdentifier.startsWith(DisguiseTypes.PLAYER.getNameSpace()) ? this.createIconForPlayer(DisguiseTypes.PLAYER.toStrippedId(disguiseIdentifier)) : this.registry.getOrDefault(disguiseIdentifier, this.defaultItem);
        return item;
    }
}

