/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.integrations.towny;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.event.NewTownEvent;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownClaimEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.event.TownSpawnEvent;
import com.palmergames.bukkit.towny.event.player.PlayerEntersIntoTownBorderEvent;
import com.palmergames.bukkit.towny.event.player.PlayerExitsFromTownBorderEvent;
import com.palmergames.bukkit.towny.event.town.TownUnclaimEvent;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.MetaDataUtil;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.abilities.impl.FlyAbility;
import xyz.nifeather.morph.api.events.gameplay.MorphTownBooleanFlagChangedEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerExecuteSkillEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerMorphEvent;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.MorphStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.integrations.towny.TownyFlags;
import xyz.nifeather.morph.misc.integrations.towny.commands.TownyIntegrationCommand;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;

public class TownyAdapter
extends MorphPluginObject
implements Listener {
    private final TownyAPI townyAPI = TownyAPI.getInstance();
    private final Bindable<Boolean> allowFlyInWilderness = new Bindable<Boolean>(false);
    private final List<Player> blockedPlayers = ObjectLists.synchronize((ObjectList)new ObjectArrayList());

    public TownyAdapter() {
        this.plugin.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> new TownyIntegrationCommand().register((Commands)event.registrar()));
    }

    @Initializer
    private void load(MorphConfigManager configManager) {
        configManager.bind(this.allowFlyInWilderness, ConfigOption.TOWNY_ALLOW_FLY_IN_WILDERNESS);
        this.allowFlyInWilderness.onValueChanged((o, n) -> this.featherMorph().getPlatform().onlinePlayersNative().forEach(p -> this.scheduleOn((Entity)p, () -> this.updatePlayer((Player)p, null))));
    }

    @EventHandler
    public void onPlayerMorph(PlayerMorphEvent event) {
        if (FeatherMorphMain.getInstance().isFolia()) {
            this.scheduleOn((Entity)event.getPlayer(), () -> this.updateDisguise(event.getPlayer(), event.getState()));
        }
    }

    private void updateDisguise(Player player, DisguiseState state) {
        if (state.disposed()) {
            return;
        }
        this.scheduleOn((Entity)player, () -> this.updateDisguise(player, state), 5);
        Location playerLocation = player.getLocation();
        Location lastLocation = state.getSessionData("fm_towny_adapter:last_location", Location.class);
        if (!playerLocation.equals((Object)lastLocation)) {
            this.updatePlayer(player, null);
            state.setSessionData("fm_towny_adapter:last_location", playerLocation);
        }
    }

    @EventHandler
    public void onTownCreate(NewTownEvent e) {
        Town town = e.getTown();
        for (BooleanDataField field : TownyFlags.FLAGS_FOR_INIT) {
            MetaDataUtil.setBoolean((TownyObject)town, (BooleanDataField)field, (boolean)((Boolean)field.getValue()), (boolean)true);
        }
    }

    @EventHandler
    public void onEnterPlot(PlayerEntersIntoTownBorderEvent e) {
        Player player = e.getPlayer();
        this.updatePlayer(player, e.getEnteredTown());
    }

    @EventHandler
    public void onTownSpawn(TownSpawnEvent e) {
        this.updatePlayer(e.getPlayer(), e.getToTown());
    }

    @EventHandler
    public void onLeavePlot(PlayerExitsFromTownBorderEvent e) {
        this.updatePlayer(e.getPlayer(), null, true);
    }

    @EventHandler
    public void onTownUnClaim(TownUnclaimEvent e) {
        e.getWorldCoord().getChunks().forEach(task -> task.thenAccept(c -> this.updatePlayersInChunk((Chunk)c, null)));
    }

    @EventHandler
    public void onTownClaim(TownClaimEvent e) {
        Town currentTown = e.getTownBlock().getTownOrNull();
        e.getTownBlock().getWorldCoord().getChunks().forEach(chunkTask -> chunkTask.thenAccept(chunk -> this.updatePlayersInChunk((Chunk)chunk, currentTown)));
    }

    @EventHandler
    public void onTownRemoveResident(TownRemoveResidentEvent e) {
        Player player = e.getResident().getPlayer();
        if (player != null) {
            this.updatePlayer(e.getResident().getPlayer(), e.getTown());
        }
    }

    @EventHandler
    public void onTownAddResident(TownAddResidentEvent e) {
        Player player = e.getResident().getPlayer();
        if (player != null) {
            this.updatePlayer(player, e.getTown());
        }
    }

    @EventHandler
    public void onEntityAddToWorld(EntityAddToWorldEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.updatePlayer(player, null);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.updatePlayer(e.getPlayer(), null);
    }

    @EventHandler
    public void onPlayerExit(PlayerQuitEvent e) {
        this.unblockPlayer(e.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        if (e.getFrom().getWorld().equals((Object)e.getTo().getWorld())) {
            this.updatePlayer(e.getPlayer(), this.townyAPI.getTown(e.getTo()));
        }
    }

    @EventHandler
    public void onDisguiseSkill(PlayerExecuteSkillEvent event) {
        Player player = event.getPlayer();
        Town town = TownyAPI.getInstance().getTown(player.getLocation());
        if (town == null) {
            return;
        }
        if (this.playerTrustedByTown(town, player)) {
            return;
        }
        boolean outsidersSkilAllowed = (Boolean)TownyFlags.ALLOW_OUTSIDERS_USE_SKILL.getValue();
        if (MetaDataUtil.hasMeta((TownyObject)town, (BooleanDataField)TownyFlags.ALLOW_OUTSIDERS_USE_SKILL)) {
            outsidersSkilAllowed = MetaDataUtil.getBoolean((TownyObject)town, (BooleanDataField)TownyFlags.ALLOW_OUTSIDERS_FLIGHT);
        }
        if (outsidersSkilAllowed) {
            return;
        }
        player.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.regionBlockedSkillString()));
        event.setCancelled(true);
    }

    @EventHandler
    public void onMorphFlagChanged(MorphTownBooleanFlagChangedEvent e) {
        this.refreshPlayersIn(e.getTown());
    }

    private void refreshPlayersIn(Town town) {
        this.featherMorph().getPlatform().onlinePlayersNative().forEach(player -> {
            Town currentTown = TownyAPI.getInstance().getTown(player.getLocation());
            if (currentTown == null || !currentTown.equals((Object)town)) {
                return;
            }
            this.updatePlayer((Player)player, currentTown);
        });
    }

    private boolean playerTrustedByTown(Town targetTown, Player player) {
        Resident resident = this.townyAPI.getResident(player);
        if (resident == null) {
            return false;
        }
        if (targetTown.getTrustedResidents().contains(resident)) {
            return true;
        }
        Town playerTown = resident.getTownOrNull();
        if (playerTown == null) {
            return false;
        }
        if (Objects.equals(playerTown.getUUID(), targetTown.getUUID())) {
            return true;
        }
        if (CombatUtil.isAlly((Town)targetTown, (Town)playerTown)) {
            return true;
        }
        return CombatUtil.isSameNation((Town)targetTown, (Town)playerTown);
    }

    private boolean allowFlightAt(Player player, @Nullable Town town) {
        if (town == null) {
            return this.allowFlyInWilderness.get();
        }
        if (this.playerTrustedByTown(town, player)) {
            return true;
        }
        if (MetaDataUtil.hasMeta((TownyObject)town, (BooleanDataField)TownyFlags.ALLOW_OUTSIDERS_FLIGHT)) {
            return MetaDataUtil.getBoolean((TownyObject)town, (BooleanDataField)TownyFlags.ALLOW_OUTSIDERS_FLIGHT);
        }
        return (Boolean)TownyFlags.ALLOW_OUTSIDERS_FLIGHT.getValue();
    }

    private void updatePlayersInChunk(Chunk chunk, Town currentTown) {
        List<Player> players = Arrays.stream(chunk.getEntities()).filter(entity -> entity.getType() == EntityType.PLAYER).map(entity -> (Player)entity).toList();
        if (players.isEmpty()) {
            return;
        }
        for (Player player : players) {
            this.updatePlayer(player, currentTown, true);
        }
    }

    public void updatePlayer(@NotNull Player player, @Nullable Town currentTown) {
        this.updatePlayer(player, currentTown, false);
    }

    public void updatePlayer(@NotNull Player player, @Nullable Town currentTown, boolean noTownLookup) {
        if (!this.worldUsingTowny(player.getWorld())) {
            this.unblockPlayer(player);
            return;
        }
        if (currentTown == null && !noTownLookup) {
            currentTown = this.townyAPI.getTown(player.getLocation());
        }
        if (this.allowFlightAt(player, currentTown)) {
            this.unblockPlayer(player);
        } else {
            this.blockPlayer(player);
        }
    }

    private boolean worldUsingTowny(World world) {
        TownyWorld townyWorld = this.townyAPI.getTownyWorld(world);
        if (townyWorld == null) {
            return false;
        }
        return townyWorld.isUsingTowny();
    }

    private void blockPlayer(Player player) {
        boolean playerAlreadyBlocked = this.blockedPlayers.contains(player);
        if (playerAlreadyBlocked) {
            return;
        }
        this.blockedPlayers.add(player);
        FlyAbility.blockPlayer(player, this);
    }

    private void unblockPlayer(Player player) {
        FlyAbility.unBlockPlayer(player, this);
        this.blockedPlayers.remove(player);
    }
}

