/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.skins;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.ProfileResult;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.misc.skins.SingleSkin;
import xyz.nifeather.morph.misc.skins.SkinCache;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.utilities.GameProfileUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class PlayerSkinProvider
extends MorphPluginObject {
    private final SkinCache skinCache = new SkinCache();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> namesToLookup = new ConcurrentHashMap<String, CompletableFuture<Optional<GameProfile>>>();
    private static final Object batchLock = new Object();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> onGoingRequests = new ConcurrentHashMap<String, CompletableFuture<Optional<GameProfile>>>();

    public static PlayerSkinProvider getInstance() {
        return PlayerSkinProviderLazyHolder.instance;
    }

    public PlayerSkinProvider() {
        this.skinCache.initializeStorage();
    }

    @Initializer
    private void load() {
        Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, task -> this.batchPlayerInfo(), 1500L, 1500L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Optional<GameProfile>> fetchPlayerInfoAsync(String name) {
        CompletableFuture<Optional<GameProfile>> future = new CompletableFuture<Optional<GameProfile>>();
        Map<String, CompletableFuture<Optional<GameProfile>>> map = this.namesToLookup;
        synchronized (map) {
            this.namesToLookup.put(name, future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchPlayerInfo() {
        Object object = batchLock;
        synchronized (object) {
            this.startBatchPlayerInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBatchPlayerInfo() {
        if (this.namesToLookup.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap toBatch = new Object2ObjectOpenHashMap();
        Map<String, CompletableFuture<Optional<GameProfile>>> map = this.namesToLookup;
        synchronized (map) {
            int currentPickIndex = 0;
            int targetAmount = Math.min(this.namesToLookup.size(), 10);
            for (String name : new ObjectArrayList(this.namesToLookup.keySet())) {
                if (currentPickIndex >= targetAmount) break;
                CompletableFuture<Optional<GameProfile>> future = this.namesToLookup.remove(name);
                toBatch.put(name.toUpperCase(), future);
                ++currentPickIndex;
            }
        }
        ObjectArrayList remainingNames = new ObjectArrayList(toBatch.keySet());
        final BiConsumer<String, @Nullable GameProfile> onRequestFinish = (arg_0, arg_1) -> this.lambda$startBatchPlayerInfo$1((List)remainingNames, (Map)toBatch, arg_0, arg_1);
        ProfileLookupCallback lookupCallback = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(String profileName, UUID profileId) {
                onRequestFinish.accept(profileName, new GameProfile(profileId, profileName));
            }

            public void onProfileLookupFailed(String profileName, Exception exception) {
                if (!(exception instanceof ProfileNotFoundException)) {
                    if (exception instanceof AuthenticationUnavailableException) {
                        PlayerSkinProvider.this.logger.info("Failed to lookup '%s' because the authentication service is not available now...".formatted(profileName));
                    } else {
                        PlayerSkinProvider.this.logger.info("Failed to lookup '%s': '%s'".formatted(profileName, exception.getMessage()));
                    }
                }
                onRequestFinish.accept(profileName, null);
            }
        };
        GameProfileRepository profileRepo = MinecraftServer.getServer().services().profileRepository();
        profileRepo.findProfilesByNames(remainingNames.toArray(new String[0]), lookupCallback);
    }

    @Nullable
    public GameProfile getCachedProfile(String name) {
        return this.skinCache.get(name).profileOptional().orElse(null);
    }

    public Optional<GameProfile> getCachedProfileOptional(String name) {
        return this.skinCache.get(name).profileOptional();
    }

    public void cacheProfile(@NotNull PlayerProfile playerProfile) {
        GameProfile gameProfile = GameProfileUtils.convertPlayerProfile(playerProfile);
        this.skinCache.cache(gameProfile);
    }

    public CompletableFuture<Optional<GameProfile>> fetchSkin(GameProfile profile) {
        if (profile.properties().containsKey((Object)"textures")) {
            Optional<GameProfile> optional = Optional.of(profile);
            this.skinCache.cache(profile);
            return CompletableFuture.completedFuture(optional);
        }
        return CompletableFuture.supplyAsync(() -> {
            MinecraftSessionService sessionService = MinecraftServer.getServer().services().sessionService();
            ProfileResult result = sessionService.fetchProfile(profile.id(), true);
            if (result != null) {
                this.skinCache.cache(result.profile());
            } else {
                this.skinCache.cache(new GameProfile(Uuids.NIL_UUID, profile.name()));
            }
            return result == null ? Optional.of(profile) : Optional.of(result.profile());
        });
    }

    public CompletableFuture<Optional<GameProfile>> fetchSkin(String profileName) {
        Player player = Bukkit.getPlayerExact((String)profileName);
        if (player != null && player.getPlayerProfile().hasTextures()) {
            GameProfile profile = NmsRecord.ofPlayer((Player)player).gameProfile;
            this.skinCache.cache(profile);
            return CompletableFuture.completedFuture(Optional.of(profile));
        }
        SkinCache.SkinRecord cachedSkin = this.skinCache.get(profileName);
        if (!cachedSkin.expired() && cachedSkin.profileOptional().isPresent()) {
            return CompletableFuture.completedFuture(cachedSkin.profileOptional());
        }
        CompletableFuture prevReq = this.onGoingRequests.getOrDefault(profileName, null);
        if (prevReq != null) {
            return prevReq;
        }
        CompletionStage req = this.fetchPlayerInfoAsync(profileName).thenCompose(rawProfileOptional -> {
            if (rawProfileOptional.isPresent()) {
                return this.fetchSkin((GameProfile)rawProfileOptional.get());
            }
            if (cachedSkin.profileOptional().isPresent()) {
                this.skinCache.cache(cachedSkin.profileOptional().get());
                return CompletableFuture.completedFuture(cachedSkin.profileOptional());
            }
            this.skinCache.cache(new GameProfile(Uuids.NIL_UUID, profileName));
            return CompletableFuture.completedFuture(Optional.empty());
        });
        ((CompletableFuture)req).exceptionally(t -> {
            this.onGoingRequests.remove(profileName);
            return Optional.empty();
        });
        ((CompletableFuture)req).thenRun(() -> this.onGoingRequests.remove(profileName));
        this.onGoingRequests.put(profileName, (CompletableFuture<Optional<GameProfile>>)req);
        return req;
    }

    public List<SingleSkin> getAllSkins() {
        return this.skinCache.listAll();
    }

    public void dropSkin(String name) {
        this.skinCache.drop(name);
    }

    public void dropAll() {
        this.skinCache.dropAll();
    }

    public void reload() {
        this.skinCache.reloadConfiguration();
    }

    public void invalidate(String name) {
        SingleSkin skin = this.skinCache.getRaw(name);
        if (skin == null) {
            return;
        }
        skin.expiresAt = 0L;
    }

    private /* synthetic */ void lambda$startBatchPlayerInfo$1(List remainingNames, Map toBatch, String name, GameProfile profile) {
        name = name.toUpperCase();
        Optional<Object> optional = profile == null ? Optional.empty() : Optional.of(profile);
        remainingNames.remove(name);
        CompletableFuture future = toBatch.getOrDefault(name, null);
        if (future == null) {
            this.logger.warn("Profile with name '%s' configured a lookup request but no callback is set?!".formatted(name));
        } else {
            future.complete(optional);
        }
    }

    private static class PlayerSkinProviderLazyHolder {
        public static final PlayerSkinProvider instance = new PlayerSkinProvider();

        private PlayerSkinProviderLazyHolder() {
        }
    }
}

