/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands.C2S;

import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.network.BasicClientHandler;
import xyz.nifeather.morph.network.annotations.Environment;
import xyz.nifeather.morph.network.annotations.EnvironmentType;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class C2SSetSingleOptionCommand
extends AbstractC2SCommand<ClientOptionEnum> {
    private final ClientOptionEnum optionEnum;
    private final String value;

    public C2SSetSingleOptionCommand(@NotNull ClientOptionEnum option, boolean value) {
        this.optionEnum = option;
        this.value = Boolean.toString(value);
    }

    public C2SSetSingleOptionCommand(@NotNull ClientOptionEnum option, String value) {
        this.optionEnum = option;
        this.value = value;
    }

    @Override
    @Environment(value=EnvironmentType.SERVER)
    public void onCommand(BasicClientHandler<?> listener) {
        listener.onOptionCommand(this);
    }

    public ClientOptionEnum getOption() {
        return this.optionEnum;
    }

    public String getValue() {
        return this.value;
    }

    public static C2SSetSingleOptionCommand fromArguments(Map<String, String> arguments) throws RuntimeException {
        String optionName = Asserts.getStringOrThrow(arguments, "option");
        ClientOptionEnum option = Arrays.stream(ClientOptionEnum.values()).filter(v -> v.networkName.equalsIgnoreCase(optionName)).findFirst().orElseThrow(() -> new RuntimeException("No matched ClientOptionEnum for input '%s'".formatted(optionName)));
        String value = Asserts.getStringOrThrow(arguments, "value");
        return new C2SSetSingleOptionCommand(option, value);
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("option", this.optionEnum.networkName, "value", this.value);
    }

    @Override
    public String getBaseName() {
        return "set_single_option";
    }

    public static enum ClientOptionEnum {
        CLIENTVIEW("clientview"),
        HUD("hud");

        public final String networkName;

        private ClientOptionEnum(String optionNetworkName) {
            this.networkName = optionNetworkName;
        }
    }
}

