/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;

public class CommandRegistriesNew {
    private final Object2ObjectArrayMap<String, Function<Map<String, String>, AbstractC2SCommand<?>>> c2sCmds = new Object2ObjectArrayMap();
    private final Object2ObjectArrayMap<String, Function<Map<String, String>, AbstractS2CCommand<?>>> s2cCmds = new Object2ObjectArrayMap();

    public CommandRegistriesNew registerC2S(String name, Function<Map<String, String>, AbstractC2SCommand<?>> function) {
        this.c2sCmds.put((Object)name, function);
        return this;
    }

    public CommandRegistriesNew registerS2C(String name, Function<Map<String, String>, AbstractS2CCommand<?>> function) {
        this.s2cCmds.put((Object)name, function);
        return this;
    }

    @NotNull
    public AbstractS2CCommand<?> createS2CCommand(String baseName, Map<String, String> args) throws RuntimeException {
        Function func = (Function)this.s2cCmds.getOrDefault((Object)baseName, null);
        return (AbstractS2CCommand)Objects.requireNonNull(func, "No Func found for command name '%s'".formatted(baseName)).apply(args);
    }

    @NotNull
    public AbstractC2SCommand<?> createC2SCommand(String baseName, Map<String, String> args) throws RuntimeException {
        Function func = (Function)this.c2sCmds.getOrDefault((Object)baseName, null);
        return (AbstractC2SCommand)Objects.requireNonNull(func, "No Func found for command name '%s'".formatted(baseName)).apply(args);
    }
}

