/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands.S2C;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.nifeather.morph.network.BasicServerHandler;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class S2CUpdatePropertiesCommand
extends AbstractS2CCommand<String> {
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public S2CUpdatePropertiesCommand(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Override
    public String getBaseName() {
        return "update_properties";
    }

    @Override
    public void onCommand(BasicServerHandler<?> handler) {
        handler.onUpdatePropertiesCommand(this);
    }

    public static S2CUpdatePropertiesCommand fromArguments(Map<String, String> arguments) throws RuntimeException {
        String propertyMapString = Asserts.getStringOrThrow(arguments, "properties");
        Map propertyMap = (Map)S2CUpdatePropertiesCommand.gson().fromJson(propertyMapString, Map.class);
        HashMap<String, String> convertedMap = new HashMap<String, String>();
        propertyMap.forEach((key, val) -> convertedMap.put("" + key, "" + val));
        return new S2CUpdatePropertiesCommand(convertedMap);
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("properties", S2CUpdatePropertiesCommand.gson().toJson(this.properties));
    }
}

