/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.master;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class NetworkDisguiseManager
extends MorphPluginObject {
    private final List<PlayerMeta> storedMeta = Collections.synchronizedList(new ObjectArrayList());
    private final List<DisguiseMeta> cachedMetas = Collections.synchronizedList(new ObjectArrayList());

    public List<PlayerMeta> listAllMeta() {
        return new ObjectArrayList(this.storedMeta);
    }

    public PlayerMeta getPlayerMeta(OfflinePlayer player) {
        PlayerMeta match = this.storedMeta.stream().filter(m -> m.uniqueId.equals(player.getUniqueId())).findFirst().orElse(null);
        if (match != null) {
            return match;
        }
        PlayerMeta newInstance = new PlayerMeta();
        newInstance.uniqueId = player.getUniqueId();
        this.storedMeta.add(newInstance);
        return newInstance;
    }

    public DisguiseMeta getDisguiseMeta(String rawString) {
        DisguiseTypes type = DisguiseTypes.fromId(rawString);
        if (this.cachedMetas.stream().noneMatch(o -> o.equals(rawString))) {
            this.cachedMetas.add(new DisguiseMeta(rawString, type));
        }
        return this.cachedMetas.stream().filter(o -> o.equals(rawString)).findFirst().orElse(null);
    }

    public void merge(List<PlayerMeta> other) {
        for (PlayerMeta otherMeta : other) {
            PlayerMeta match = this.storedMeta.stream().filter(meta -> meta.uniqueId.equals(otherMeta.uniqueId)).findFirst().orElse(null);
            if (match == null) {
                PlayerMeta newInstance = new PlayerMeta();
                newInstance.uniqueId = otherMeta.uniqueId;
                newInstance.addUnlockedDisguiseIdentifier(otherMeta.getUnlockedDisguiseIdentifiers());
                this.storedMeta.add(newInstance);
                continue;
            }
            match.addUnlockedDisguiseIdentifier(other.getFirst().getUnlockedDisguiseIdentifiers());
        }
    }
}

