/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.slave;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.interfaces.IManagePlayerData;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.network.multiInstance.protocol.Operation;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SSyncDisguiseCommand;
import xyz.nifeather.morph.network.multiInstance.slave.SlaveInstance;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class NetworkDataHolder
extends MorphPluginObject
implements IManagePlayerData {
    private final Map<UUID, PlayerMeta> localMetaMap = new ConcurrentHashMap<UUID, PlayerMeta>();
    private final SlaveInstance bindingSlave;
    private final Map<String, DisguiseMeta> cachedMetas = new ConcurrentHashMap<String, DisguiseMeta>();

    public NetworkDataHolder(SlaveInstance bindingSlave) {
        this.bindingSlave = bindingSlave;
    }

    @Override
    @Nullable
    public DisguiseMeta getDisguiseMeta(String rawString) {
        DisguiseMeta cached = this.cachedMetas.getOrDefault(rawString, null);
        if (cached != null) {
            return cached;
        }
        DisguiseTypes type = DisguiseTypes.fromId(rawString);
        DisguiseMeta meta = new DisguiseMeta(rawString, type);
        this.cachedMetas.put(rawString, meta);
        return meta;
    }

    @Override
    public List<DisguiseMeta> getAvaliableDisguisesFor(Player player) {
        PlayerMeta playerMeta = this.getPlayerMeta((OfflinePlayer)player);
        return playerMeta.getUnlockedDisguises();
    }

    @Override
    public boolean grantMorphToPlayer(Player player, String disguiseIdentifier) {
        if (!this.bindingSlave.isOnline()) {
            this.logger.error("We are not connected with master server! Refusing to update unlock state...");
            return false;
        }
        if (this.getPlayerMeta((OfflinePlayer)player).getUnlockedDisguiseIdentifiers().stream().anyMatch(str -> str.equals(disguiseIdentifier))) {
            return false;
        }
        this.bindingSlave.sendCommand(new MIC2SSyncDisguiseCommand(Operation.ADD_IF_ABSENT, List.of(disguiseIdentifier), player.getUniqueId()));
        return true;
    }

    @Override
    public boolean revokeMorphFromPlayer(Player player, String disguiseIdentifier) {
        if (!this.bindingSlave.isOnline()) {
            this.logger.error("We are not connected with master server! Refusing to update unlock state...");
            return false;
        }
        if (this.getPlayerMeta((OfflinePlayer)player).getUnlockedDisguiseIdentifiers().stream().noneMatch(str -> str.equals(disguiseIdentifier))) {
            return false;
        }
        this.bindingSlave.sendCommand(new MIC2SSyncDisguiseCommand(Operation.REMOVE, List.of(disguiseIdentifier), player.getUniqueId()));
        return true;
    }

    @Override
    @NotNull
    public PlayerMeta getPlayerMeta(OfflinePlayer player) {
        UUID uuid = player.getUniqueId();
        PlayerMeta tracked = this.localMetaMap.getOrDefault(uuid, null);
        if (tracked != null) {
            return tracked;
        }
        PlayerMeta metaInstance = new PlayerMeta();
        metaInstance.uniqueId = player.getUniqueId();
        metaInstance.playerName = player.getName();
        this.localMetaMap.put(uuid, metaInstance);
        return metaInstance;
    }

    @Override
    public boolean reloadConfiguration() {
        this.logger.info("[Slave@NetworkData] Dropping cached network player meta...");
        this.dropAll();
        this.bindingSlave.requestDataSync();
        return true;
    }

    public void dropAll() {
        this.localMetaMap.clear();
    }

    @Override
    public boolean saveConfiguration() {
        return true;
    }

    @Override
    public void shouldLoadAllData(boolean shouldLoadAllData) {
    }

    @Override
    public List<PlayerMeta> listAll() {
        return this.localMetaMap.values().stream().toList();
    }
}

