/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.providers.disguise;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.abilities.AbilityManager;
import xyz.nifeather.morph.abilities.IAbility;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.MorphStrings;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.waypoint.DisguiseWaypointUpdater;
import xyz.nifeather.morph.network.PlayerOptions;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.network.server.ServerSetEquipCommand;
import xyz.nifeather.morph.providers.disguise.DisguiseProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;
import xyz.nifeather.morph.skills.ISkill;
import xyz.nifeather.morph.skills.SkillManager;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;
import xyz.nifeather.morph.storage.skill.SkillAbilityConfigContainer;

public abstract class DefaultDisguiseProvider
extends DisguiseProvider {
    @Resolved
    private SkillManager skillHandler;
    @Resolved
    private AbilityManager abilityHandler;
    @Resolved
    private MorphClientHandler clientHandler;
    @Resolved
    private MessageStore<?> messageStore;
    @Resolved
    private RevealingHandler revealingHandler;
    @NotNull
    public static final NamespacedKey WAYPOINT_TRANSMIT_MODIFIER_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:waypoint_transmit_modifier"));

    @Override
    @NotNull
    public DisguiseBackend<?, ?> getPreferredBackend() {
        return this.getMorphManager().getDefaultBackend();
    }

    @Override
    public boolean updateDisguise(Player player, DisguiseState state) {
        DisguiseWrapper<?> disguise = state.getDisguiseWrapper();
        PlayerOptions<Player> option = this.clientHandler.getPlayerOption(player, true);
        boolean haveSkill = state.haveSkill();
        if (option.displayDisguiseOnHUD && this.plugin.getCurrentTick() % (long)(haveSkill ? 2 : 5) == 0L) {
            short stateBit;
            String locale = MessageUtils.getLocale(player);
            short bit = 0;
            if (haveSkill) {
                bit = (short)(bit | 1);
            }
            bit = state.skillInCooldown() ? (short)(bit | 2) : (short)(bit | 4);
            RevealingHandler.RevealingLevel revLevel = this.revealingHandler.getRevealingLevel(player);
            switch (revLevel) {
                case SAFE: {
                    bit = (short)(bit | 8);
                    break;
                }
                case SUSPECT: {
                    bit = (short)(bit | 0x10);
                    break;
                }
                case REVEALED: {
                    bit = (short)(bit | 0x20);
                }
            }
            MessageConfiguration msgConfig = state.getSessionData("MESSAGE_CONFIG", MessageConfiguration.class);
            if (msgConfig == null) {
                msgConfig = MessageConfiguration.DEFAULT;
            }
            if ((stateBit = msgConfig.statusBit()) != bit || !msgConfig.locale.equals(locale)) {
                boolean disguiseRevealed;
                FormattableMessage msg = haveSkill ? (!state.skillInCooldown() ? MorphStrings.disguisingWithSkillAvaliableString() : MorphStrings.disguisingWithSkillPreparingString()) : MorphStrings.disguisingAsString();
                boolean bl = disguiseRevealed = revLevel == RevealingHandler.RevealingLevel.REVEALED || revLevel == RevealingHandler.RevealingLevel.SUSPECT;
                Component display = disguiseRevealed ? ((TextComponent)Component.empty().append(state.getPlayerDisplay())).append((revLevel == RevealingHandler.RevealingLevel.REVEALED ? MorphStrings.revealed() : MorphStrings.partialRevealed()).toComponent(locale)) : state.getPlayerDisplay();
                msgConfig = msgConfig.withDisplay(msg.resolve("what", display).toComponent(locale, this.messageStore)).withBit(bit).withLocale(locale);
                state.setSessionData("MESSAGE_CONFIG", msgConfig);
            }
            player.sendActionBar(msgConfig.display);
        }
        try {
            disguise.update(state, player);
        }
        catch (Throwable t) {
            this.logger.error("Error occurred while updating disguise!", t);
            return false;
        }
        return true;
    }

    protected AttributeInstance acquireAttributeOrThrow(Player player, Attribute attribute) {
        return Objects.requireNonNull(player.getAttribute(attribute), "Player don't have a '%s' attribute, you might using a broken server implementation.".formatted(attribute.key().asString()));
    }

    protected void mutePlayerWaypoint(Player player) {
        AttributeInstance attribute = this.acquireAttributeOrThrow(player, Attribute.WAYPOINT_TRANSMIT_RANGE);
        if (attribute.getModifier((Key)WAYPOINT_TRANSMIT_MODIFIER_KEY) == null) {
            attribute.addTransientModifier(new AttributeModifier(WAYPOINT_TRANSMIT_MODIFIER_KEY, -1.0, AttributeModifier.Operation.ADD_SCALAR));
        }
    }

    protected void recoverPlayerWaypoint(Player player) {
        this.acquireAttributeOrThrow(player, Attribute.WAYPOINT_TRANSMIT_RANGE).removeModifier((Key)WAYPOINT_TRANSMIT_MODIFIER_KEY);
    }

    protected void enableDisguiseWaypoint(DisguiseState state) {
        DisguiseWaypointUpdater disguiseWaypoint = state.waypointUpdater();
        disguiseWaypoint.enabled(true);
    }

    public void disableDisguiseWaypoint(DisguiseState state) {
        DisguiseWaypointUpdater disguiseWaypoint = state.waypointUpdater();
        disguiseWaypoint.enabled(false);
    }

    @Override
    @NotNull
    public List<AbstractS2CCommand<?>> getInitialSyncCommands(DisguiseState state) {
        if (this.skillHandler.hasSpeficSkill(state.skillLookupIdentifier(), SkillNames.FAKE_EQUIP) && this.clientHandler.getPlayerVersion(state.getPlayer()) < 16) {
            DisguiseEquipment eqiupment = state.getDisguiseEquipment();
            ObjectArrayList list = new ObjectArrayList();
            this.addIfPresents(eqiupment, list, EquipmentSlot.HAND);
            this.addIfPresents(eqiupment, list, EquipmentSlot.OFF_HAND);
            this.addIfPresents(eqiupment, list, EquipmentSlot.HEAD);
            this.addIfPresents(eqiupment, list, EquipmentSlot.CHEST);
            this.addIfPresents(eqiupment, list, EquipmentSlot.LEGS);
            this.addIfPresents(eqiupment, list, EquipmentSlot.FEET);
            return list;
        }
        return List.of();
    }

    private void addIfPresents(EntityEquipment equipment, ObjectArrayList<AbstractS2CCommand<?>> list, EquipmentSlot slot) {
        ItemStack item = equipment.getItem(slot);
        if (item.getType() != Material.AIR) {
            list.add((Object)new ServerSetEquipCommand(item, slot));
        }
    }

    @Override
    public void buildDisguise(DisguiseState state, @Nullable Entity targetEntity) throws ParseErrorException {
        List<IAbility<?>> abilities = this.abilityHandler.getAbilitiesFor(state.skillLookupIdentifier());
        state.getAbilityUpdater().setAbilities(abilities);
        Map<NamespacedKey, ISkillAbilityOption> abilityOptions = this.abilityHandler.getOptionsFor(state.skillLookupIdentifier());
        abilityOptions.forEach((id, config) -> state.getAbilityUpdater().setAbilityConfig(id.asString(), (ISkillAbilityOption)config));
        SkillAbilityConfigContainer config2 = this.skillHandler.getConfiguration(state.skillLookupIdentifier());
        if (config2 == null) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.warn("The skill lookup '{}' does not have a matching skill/ability configuration", (Object)state.skillLookupIdentifier());
            }
            return;
        }
        ISkill<?> skill = this.skillHandler.getSkill(config2.getSkillIdentifier().key().asString());
        Object option = this.skillHandler.lookupOptionFor(skill, state.skillLookupIdentifier());
        state.bindSkill(skill, option);
        state.setDefaultSkillCooldown(config2.getSkillCooldown());
    }

    private record MessageConfiguration(short statusBit, Component display, String locale) {
        public static final MessageConfiguration DEFAULT = new MessageConfiguration(-1, MiniMessage.miniMessage().deserialize((Object)"<yellow>missingno"), "missingno");

        public MessageConfiguration withBit(short bit) {
            return new MessageConfiguration(bit, this.display, this.locale);
        }

        public MessageConfiguration withDisplay(Component display) {
            return new MessageConfiguration(this.statusBit, display, this.locale);
        }

        public MessageConfiguration withLocale(String newLocale) {
            return new MessageConfiguration(this.statusBit, this.display, newLocale);
        }
    }
}

