/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.providers.disguise;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.MorphStrings;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.values.PlayerProperties;
import xyz.nifeather.morph.misc.skins.PlayerSkinProvider;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.providers.animation.AnimationProvider;
import xyz.nifeather.morph.providers.animation.provider.PlayerAnimationProvider;
import xyz.nifeather.morph.providers.disguise.DefaultDisguiseProvider;
import xyz.nifeather.morph.providers.disguise.DisguiseResult;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.utilities.GameProfileUtils;

public class PlayerDisguiseProvider
extends DefaultDisguiseProvider {
    private final PlayerAnimationProvider animationProvider = new PlayerAnimationProvider();
    @Resolved(shouldSolveImmediately=true)
    private MorphClientHandler clientHandler;

    @Override
    @NotNull
    public String getNameSpace() {
        return DisguiseTypes.PLAYER.getNameSpace();
    }

    @Override
    public AnimationProvider getAnimationProvider() {
        return this.animationProvider;
    }

    @Override
    public boolean isValid(String rawIdentifier) {
        return DisguiseTypes.fromId(rawIdentifier) == DisguiseTypes.PLAYER;
    }

    @Override
    @NotNull
    public DisguiseResult makeWrapper(Player player, DisguiseMeta disguiseMeta, @Nullable Entity targetEntity) {
        if (this.getMorphManager().getBannedDisguises().contains("minecraft:player")) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.disguiseBannedOrNotSupportedString()));
            return DisguiseResult.fail();
        }
        String id = disguiseMeta.getIdentifier();
        DisguiseBackend<?, ?> backend = this.getPreferredBackend();
        if (DisguiseTypes.fromId(id) != DisguiseTypes.PLAYER) {
            return DisguiseResult.fail();
        }
        DisguiseWrapper<?> wrapper = backend.createPlayerInstance(disguiseMeta.playerDisguiseTargetName);
        Objects.requireNonNull(wrapper, "Null wrapper at where it shouldn't be?!");
        return DisguiseResult.success(wrapper);
    }

    @Override
    public void buildDisguise(DisguiseState state, @Nullable Entity targetEntity) throws ParseErrorException {
        Player player = state.getPlayer();
        ItemStack mainHandItem = player.getEquipment().getItemInMainHand();
        String id = state.getDisguiseIdentifier();
        PropertyHandler propertyHandler = state.disguisePropertyHandler();
        PlayerProperties playerProperties = DisguiseProperties.INSTANCE.getOrThrow(PlayerProperties.class);
        String playerDisguiseTargetName = DisguiseTypes.PLAYER.toStrippedId(id);
        GameProfile fallbackSkin = PlayerSkinProvider.getInstance().getCachedProfileOptional(DisguiseTypes.PLAYER.toStrippedId(id)).orElse(new GameProfile(UUID.randomUUID(), playerDisguiseTargetName));
        propertyHandler.set(playerProperties.SKIN, fallbackSkin);
        if (mainHandItem.getType() == Material.PLAYER_HEAD) {
            GameProfile gameProfile = this.getGameProfile(mainHandItem);
            if (gameProfile == null) {
                player.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.invalidSkinString()));
                throw ParseErrorException.forProperty("player/skin").withLocalizableMessage(MorphStrings.invalidSkinString()).withMessage("Invalid GameProfile for the given player head").byMethod("PlayerDisguiseProvider#buildDisguise").create();
            }
            if (gameProfile.name().equals(playerDisguiseTargetName)) {
                propertyHandler.set(playerProperties.SKIN, gameProfile);
            }
        }
        PlayerSkinProvider.getInstance().fetchSkin(playerDisguiseTargetName).thenAccept(optional -> {
            if (state.disposed() || !fallbackSkin.equals((Object)propertyHandler.get(playerProperties.SKIN))) {
                return;
            }
            GameProfile outcomingProfile = optional.orElse(fallbackSkin);
            this.scheduleOn((Entity)player, () -> propertyHandler.set(playerProperties.SKIN, outcomingProfile));
        });
        super.buildDisguise(state, targetEntity);
    }

    @Override
    public void onDisguiseApply(DisguiseState state) {
        this.mutePlayerWaypoint(state.getPlayer());
        this.enableDisguiseWaypoint(state);
        DisguiseWrapper<?> wrapper = state.getDisguiseWrapper();
        PlayerProperties playerProperties = DisguiseProperties.INSTANCE.getOrThrow(PlayerProperties.class);
        PropertyHandler propertyHandler = state.disguisePropertyHandler();
        String playerDisguiseTargetName = DisguiseTypes.PLAYER.toStrippedId(state.getDisguiseIdentifier());
        wrapper.applySkin(propertyHandler.getOr(playerProperties.SKIN, new GameProfile(UUID.randomUUID(), playerDisguiseTargetName)));
        propertyHandler.hookOnPropertyWrite((property, value) -> {
            if (property.equals(playerProperties.SKIN)) {
                GameProfile profile = (GameProfile)value;
                wrapper.applySkin(profile);
            }
        });
        super.onDisguiseApply(state);
    }

    @Override
    public boolean unMorph(Player player, DisguiseState state) {
        this.recoverPlayerWaypoint(player);
        this.disableDisguiseWaypoint(state);
        return super.unMorph(player, state);
    }

    @Override
    public void onPlayerJoinWithDisguise(DisguiseState state) {
        this.mutePlayerWaypoint(state.getPlayer());
        super.onPlayerJoinWithDisguise(state);
    }

    @Override
    public void onPlayerQuitWithDisguise(DisguiseState state) {
        this.recoverPlayerWaypoint(state.getPlayer());
        super.onPlayerQuitWithDisguise(state);
    }

    private GameProfile getGameProfile(ItemStack item) {
        if (item.getType() != Material.PLAYER_HEAD) {
            return null;
        }
        PlayerProfile profile = ((SkullMeta)item.getItemMeta()).getPlayerProfile();
        if (profile == null) {
            return null;
        }
        return GameProfileUtils.convertPlayerProfile(profile);
    }

    @Override
    public List<String> getAllAvailableDisguises() {
        List<Player> onlinePlayers = this.featherMorph().getPlatform().onlinePlayersNative();
        ObjectArrayList list = new ObjectArrayList();
        onlinePlayers.forEach(p -> list.add((Object)p.getName()));
        return list;
    }

    @Override
    public boolean canCloneEquipment(DisguiseMeta info, Entity targetEntity, DisguiseState theirState) {
        if (theirState != null) {
            DisguiseTypes type = DisguiseTypes.fromId(theirState.getDisguiseIdentifier());
            return type == DisguiseTypes.PLAYER && type.toStrippedId(theirState.getDisguiseIdentifier()).equals(info.playerDisguiseTargetName);
        }
        if (!(targetEntity instanceof Player)) {
            return false;
        }
        Player targetPlayer = (Player)targetEntity;
        return targetPlayer.getName().equals(info.playerDisguiseTargetName);
    }

    @Override
    public boolean validForClient(DisguiseState state) {
        return true;
    }

    @Override
    public Component getDisplayName(String disguiseIdentifier, String locale) {
        String playerName = DisguiseTypes.PLAYER.toStrippedId(disguiseIdentifier);
        Player player = Bukkit.getPlayerExact((String)playerName);
        Object finalName = player != null ? player.displayName() : Component.text((String)playerName);
        return finalName;
    }
}

