/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Bindables;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.IBindable;
import xyz.nifeather.morph.shaded.pluginbase.WeakReferenceList;

public class Bindable<T>
implements IBindable<T> {
    private T value;
    private final WeakReferenceList<Bindable<T>> binds = new WeakReferenceList();
    private int triggers;
    @Nullable
    private Bindable<T> bindTarget;
    private final WeakReference<Bindable<T>> weakRef = new WeakReference<Bindable>(this);
    private final List<BiConsumer<T, T>> valueChangeConsumers = new ObjectArrayList();

    public Bindable() {
    }

    public Bindable(T value) {
        this.value = value;
    }

    public void set(T val) {
        if (this.value == val) {
            return;
        }
        T oldVal = this.value;
        this.value = val;
        this.triggerValueChange(this, oldVal, val);
    }

    private void syncValue(Bindable<T> source, T newVal) {
        if (source == this || this.value == newVal) {
            return;
        }
        T oldVal = this.value;
        this.value = newVal;
        this.triggerValueChange(source, oldVal, newVal);
    }

    private void triggerValueChange(Bindable<T> source, T oldVal, T newVal) {
        ++this.triggers;
        if (this.triggers >= 5) {
            this.removeReleasedRefs();
            this.triggers = 0;
        }
        this.valueChangeConsumers.forEach(c -> c.accept(oldVal, newVal));
        this.binds.forEach(b -> {
            if (b == this || b == null) {
                return;
            }
            b.syncValue(source, newVal);
        });
    }

    @ApiStatus.Internal
    public void setInternal(Object val) {
        this.set(val);
    }

    @ApiStatus.Internal
    @Nullable
    public T tryCast(Object val) {
        try {
            return (T)val;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public T get() {
        return this.value;
    }

    private void removeReleasedRefs() {
        this.binds.removeNull();
    }

    @Override
    public void bindTo(Bindable<T> other) {
        if (other == null || other == this || this.binds.contains((Bindable<WeakReference<Bindable<T>>>)((Object)other.weakRef))) {
            return;
        }
        if (this.bindTarget != null) {
            this.unBindFrom(this.bindTarget);
        }
        other.binds.add(this.weakRef);
        this.binds.add(other.weakRef);
        this.set(other.value);
        this.bindTarget = other;
    }

    @Override
    public void bindTo(@NotNull IBindable<T> other) {
        if (!(other instanceof Bindable)) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7684\u76ee\u6807\u4e0d\u662fBindable\u5b9e\u4f8b");
        }
        Bindable bindable = (Bindable)other;
        this.bindTo(bindable);
    }

    public void unBindFrom(Bindable<T> other) {
        if (other == null || other == this) {
            return;
        }
        if (this.bindTarget == null) {
            return;
        }
        if (this.bindTarget != other) {
            throw new RuntimeException("Trying to unbind from a target that were not bind to: %s".formatted(this.toStringSuper(), other.toStringSuper()));
        }
        this.bindTarget.binds.remove((Bindable<WeakReference<Bindable<T>>>)((Object)this.weakRef));
        this.binds.remove((Bindable<WeakReference<Bindable<T>>>)((Object)this.bindTarget.weakRef));
        this.bindTarget = null;
    }

    public void unBindListeners() {
        this.valueChangeConsumers.clear();
    }

    public void unBindBindings() {
        for (Bindable<T> bind : this.binds) {
            bind.unBindFrom(this);
        }
    }

    public void unBindAll() {
        this.unBindBindings();
        this.unBindListeners();
        if (this.bindTarget != null) {
            this.unBindFrom(this.bindTarget);
        }
    }

    public void onValueChanged(BiConsumer<T, T> consumer) {
        this.onValueChanged(consumer, false);
    }

    @Override
    public void onValueChanged(BiConsumer<T, T> consumer, boolean runOnce) {
        this.valueChangeConsumers.add(consumer);
        if (runOnce) {
            consumer.accept(null, this.value);
        }
    }

    public void dispose() {
        this.unBindAll();
    }

    public String toString() {
        return "%s(%s)".formatted(this.value, this.toStringSuper());
    }

    private String toStringSuper() {
        return super.toString();
    }
}

