/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.impl;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.skills.MorphSkill;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public abstract class DelayedMorphSkill<T extends ISkillAbilityOption>
extends MorphSkill<T> {
    @Resolved
    private MorphManager manager;

    @Override
    public final int executeSkill(Player player, DisguiseState state, T option) throws ExecutionErrorException {
        if (option == null) {
            throw ExecutionErrorException.forMethod("executeSkill").withMessage("%s does not have a option set".formatted(state.getDisguiseIdentifier())).create();
        }
        ExecuteResult executeResult = this.preExecute(player, state, option);
        if (executeResult.success()) {
            this.addDelayedSkillSchedule(player, () -> this.executeDelayedSkill(player, state, option), this.getExecuteDelay(option));
        }
        return executeResult.cd();
    }

    protected abstract ExecuteResult preExecute(Player var1, DisguiseState var2, @NotNull T var3) throws ExecutionErrorException;

    protected abstract int getExecuteDelay(T var1);

    protected abstract void executeDelayedSkill(Player var1, DisguiseState var2, T var3);

    protected void addDelayedSkillSchedule(Player player, Runnable execution, int delay) {
        DisguiseState state = this.manager.getDisguiseStateFor(player);
        if (state == null) {
            return;
        }
        if (delay <= 0) {
            execution.run();
            return;
        }
        this.scheduleOn((Entity)player, () -> {
            if (!player.isOnline()) {
                return;
            }
            DisguiseState currentState = this.manager.getDisguiseStateFor(player);
            if (currentState != null && currentState.getDisguiseWrapper().equals(state.getDisguiseWrapper())) {
                execution.run();
            }
        }, delay);
    }

    protected record ExecuteResult(boolean success, int cd) {
        public static ExecuteResult success(int cd) {
            return new ExecuteResult(true, cd);
        }

        public static ExecuteResult fail(int cd) {
            return new ExecuteResult(false, cd);
        }
    }
}

