/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.impl;

import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.RandomStringUtils;
import org.bukkit.Difficulty;
import org.bukkit.NamespacedKey;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.SkillStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.values.GuardianProperties;
import xyz.nifeather.morph.skills.impl.DelayedMorphSkill;
import xyz.nifeather.morph.skills.options.NoOpConfiguration;

public class GuardianSkill
extends DelayedMorphSkill<NoOpConfiguration> {
    private final GuardianProperties properties = DisguiseProperties.INSTANCE.getOrThrow(GuardianProperties.class);
    private static final int MAX_TRACE_DISTANCE = 16;
    private static final String DATAKEY = "feathermorph:guardian_attack_target";
    private static final String EXECUTE_ID = "feathermorph:guardian_skill_execute_id";

    @Override
    protected int getExecuteDelay(NoOpConfiguration option) {
        return 80;
    }

    @Override
    protected DelayedMorphSkill.ExecuteResult preExecute(Player player, DisguiseState state, @NotNull NoOpConfiguration option) throws ExecutionErrorException {
        if (state.getEntityType() != EntityType.GUARDIAN) {
            throw ExecutionErrorException.forMethod("preExecute").withMessage("This skill is only available for guardian disguises!").create();
        }
        int distanceLimit = 16;
        Entity targetEntity = player.getTargetEntity(distanceLimit);
        if (targetEntity == null) {
            this.sendDenyMessageToPlayer(player, SkillStrings.noTargetString().withLocale(MessageUtils.getLocale(player)).resolve("distance", "" + distanceLimit).toComponent());
            return DelayedMorphSkill.ExecuteResult.fail(20);
        }
        if (!(targetEntity instanceof LivingEntity)) {
            Component component = SkillStrings.targetNotSuitableString().withLocale(MessageUtils.getLocale(player)).toComponent();
            this.sendDenyMessageToPlayer(player, component);
            return DelayedMorphSkill.ExecuteResult.fail(20);
        }
        LivingEntity living = (LivingEntity)targetEntity;
        state.disguisePropertyHandler().set(this.properties.ATTACK_TARGET, targetEntity.getEntityId());
        state.getDisguiseWrapper().writeProperty(this.properties.ATTACK_TARGET, targetEntity.getEntityId());
        RandomStringUtils.secure();
        String id = RandomStringUtils.randomAlphabetic((int)8);
        state.setSessionData(DATAKEY, targetEntity);
        state.setSessionData(EXECUTE_ID, id);
        this.scheduleOn((Entity)player, () -> this.updateState(state, player, living, id));
        return DelayedMorphSkill.ExecuteResult.success(0);
    }

    private void updateState(DisguiseState state, Player player, LivingEntity targetEntity, String executeID) {
        if (state.disposed()) {
            return;
        }
        if (!state.getSessionDataOr(EXECUTE_ID, String.class, "").equals(executeID)) {
            return;
        }
        int id = targetEntity.equals((Object)player.getTargetEntity(16)) ? targetEntity.getEntityId() : 0;
        state.disguisePropertyHandler().set(this.properties.ATTACK_TARGET, id);
        state.getDisguiseWrapper().writeProperty(this.properties.ATTACK_TARGET, id);
        this.scheduleOn((Entity)player, () -> this.updateState(state, player, targetEntity, executeID), 5);
    }

    @Override
    protected void executeDelayedSkill(Player player, DisguiseState state, NoOpConfiguration option) {
        GuardianProperties properties = DisguiseProperties.INSTANCE.getOrThrow(GuardianProperties.class);
        state.disguisePropertyHandler().set(properties.ATTACK_TARGET, 0);
        state.getDisguiseWrapper().writeProperty(properties.ATTACK_TARGET, 0);
        state.removeSessionData(EXECUTE_ID);
        LivingEntity platformEntity = state.getSessionData(DATAKEY, LivingEntity.class);
        if (platformEntity == null) {
            return;
        }
        state.removeSessionData(DATAKEY);
        double magicDamage = 1.0;
        if (platformEntity.getWorld().getDifficulty() == Difficulty.HARD) {
            magicDamage += 2.0;
        }
        if (state.getEntityType() == EntityType.ELDER_GUARDIAN) {
            magicDamage += 2.0;
        }
        if (!platformEntity.equals((Object)player.getTargetEntity(16))) {
            return;
        }
        DamageSource magicDamageSource = DamageSource.builder((DamageType)DamageType.INDIRECT_MAGIC).withDirectEntity((Entity)player).withDamageLocation(player.getLocation()).build();
        platformEntity.damage(magicDamage, magicDamageSource);
        double directDamage = switch (platformEntity.getWorld().getDifficulty()) {
            default -> throw new MatchException(null, null);
            case Difficulty.PEACEFUL -> 0.0;
            case Difficulty.EASY -> 4.0;
            case Difficulty.NORMAL -> 6.0;
            case Difficulty.HARD -> 9.0;
        };
        DamageSource directDamageSource = DamageSource.builder((DamageType)DamageType.GENERIC).withDirectEntity((Entity)player).withDamageLocation(player.getLocation()).build();
        platformEntity.damage(directDamage, directDamageSource);
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return SkillNames.GUARDIAN;
    }

    @Override
    public ISkillAbilityOptionHandler<NoOpConfiguration> optionHandler() {
        return NoOpConfiguration.OPTION_HANDLER;
    }
}

