/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.updates;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.command.ServerCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.UpdateStrings;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.updates.Platforms;
import xyz.nifeather.morph.updates.SingleUpdateInfoMeta;
import xyz.nifeather.morph.updates.VersionHandling;

public class UpdateHandler
extends MorphPluginObject {
    @Resolved(shouldSolveImmediately=true)
    private FeatherMorphMain plugin;
    private final AtomicInteger requestId = new AtomicInteger(0);
    private final Bindable<Boolean> checkUpdate = new Bindable<Boolean>(true);
    private volatile CompletableFuture<CheckResult> runningFuture;
    private final Object lock = new Object();
    private final FormattableMessage messageHeaderFooter = UpdateStrings.messageHeaderFooter();
    private final FormattableMessage noNewVersionAvailable = UpdateStrings.noNewVersionAvailable();
    @Nullable
    private FormattableMessage msgPrimary;
    @Nullable
    private FormattableMessage msgSecondary;
    private boolean updateAvailable = false;

    @Initializer
    private void load(MorphConfigManager config) {
        config.bind(this.checkUpdate, ConfigOption.CHECK_UPDATE);
        this.update();
    }

    private void update() {
        this.addSchedule(this::update, 216000);
        if (this.checkUpdate.get().booleanValue()) {
            this.checkUpdate(true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<CheckResult> checkUpdate(boolean sendMessages, @Nullable CommandSender forwardTarget) {
        CompletableFuture<CheckResult> newFuture;
        Object object = this.lock;
        synchronized (object) {
            if (this.runningFuture != null && this.runningFuture.state() == Future.State.RUNNING) {
                return this.runningFuture;
            }
            this.runningFuture = null;
            newFuture = this.doCheckUpdateAsync(sendMessages, forwardTarget);
            this.runningFuture = newFuture;
        }
        newFuture.thenRun(() -> {
            Object object = this.lock;
            synchronized (object) {
                this.runningFuture = null;
            }
        });
        return newFuture;
    }

    private CompletableFuture<CheckResult> doCheckUpdateAsync(boolean sendMessages, @Nullable CommandSender forwardTarget) {
        return CompletableFuture.supplyAsync(() -> this.doCheckUpdate(sendMessages, forwardTarget));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckResult doCheckUpdate(boolean sendMessages, @Nullable CommandSender forwardTarget) {
        this.logger.info("Checking updates...");
        this.updateAvailable = false;
        int reqId = this.requestId.addAndGet(1);
        try (HttpClient httpClient = null;){
            String urlString = "https://api.modrinth.com/v2/project/feathermorph/version?game_versions=[\"%s\"]";
            urlString = urlString.formatted(Bukkit.getMinecraftVersion()).replace("[", "%5B").replace("]", "%5D").replace("\"", "%22");
            URI uri = new URI(urlString);
            HttpRequest request = HttpRequest.newBuilder().GET().uri(uri).timeout(Duration.ofSeconds(10L)).header("User-Agent", "feathermorph").build();
            httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                this.logger.error("Failed to check update: Server returned HTTP code {}", (Object)response.statusCode());
                this.logger.error("Server response: {}", (Object)response.body());
                CheckResult checkResult = CheckResult.FAIL;
                return checkResult;
            }
            CheckResult checkResult = this.onUpdateReqFinish(response.body(), reqId, sendMessages, forwardTarget);
            return checkResult;
        }
    }

    private void onUpdateReqFail(Throwable e, int reqId) {
        if (this.requestId.get() != reqId) {
            return;
        }
        this.logger.error("Failed checking update", e);
    }

    private CheckResult onUpdateReqFinish(String responseStr, int reqId, boolean sendMessages, @Nullable CommandSender forwardTarget) {
        if (this.requestId.get() != reqId) {
            return CheckResult.FAIL;
        }
        try {
            Gson gson = new GsonBuilder().create();
            ArrayList versionList = (ArrayList)gson.fromJson(responseStr, ArrayList.class);
            ObjectArrayList metaList = new ObjectArrayList();
            for (Object o : versionList) {
                if (o instanceof Map) {
                    Map map = (Map)o;
                    metaList.add((Object)SingleUpdateInfoMeta.fromMap(map));
                    continue;
                }
                this.logger.warn("Cant deserialize element to SingleUpdateInfoMeta: Not a map (" + String.valueOf(o) + ")");
            }
            SingleUpdateInfoMeta matchMeta = metaList.stream().filter(m -> {
                List<String> supportedLoaders = m.supportedLoaders;
                if (supportedLoaders == null) {
                    return false;
                }
                boolean isRelease = "Release".equalsIgnoreCase(m.versionType);
                boolean loaderMatch = supportedLoaders.stream().anyMatch(s -> s.equalsIgnoreCase(Platforms.fromName(Bukkit.getName()).getImplName()));
                return isRelease && loaderMatch;
            }).findFirst().orElse(null);
            if (matchMeta == null) {
                this.logger.error("Unable to check update: This version of Minecraft is not listed yet, or your server '%s' is not supported".formatted(Bukkit.getName()));
                return CheckResult.NOT_LISTED_OR_UNSUPPORTED;
            }
            VersionHandling.VersionInfo currentVersion = VersionHandling.toVersionInfo(this.plugin.getPluginMeta().getVersion());
            VersionHandling.VersionInfo latestVersion = VersionHandling.toVersionInfo(matchMeta.versionNumber);
            if (latestVersion.isInvalid()) {
                this.logger.error("Null version number from response: " + gson.toJson((Object)matchMeta));
                return CheckResult.FAIL;
            }
            VersionHandling.CompareResult compare = currentVersion.compare(latestVersion);
            if (compare == VersionHandling.CompareResult.EQUAL) {
                this.logger.info("Already on the latest version for " + Bukkit.getMinecraftVersion());
                return CheckResult.ALREADY_LATEST;
            }
            if (compare == VersionHandling.CompareResult.INPUT_OLDER) {
                this.logger.info("Your version is newer than released for %s!".formatted(Bukkit.getMinecraftVersion()));
                return CheckResult.CURRENT_IS_NEWER;
            }
            if (compare == VersionHandling.CompareResult.NOT_ON_SAME_CHANNEL) {
                this.logger.info("We are not on the same channel with the latest release, assuming there is a new update!");
            }
            Set serverOps = Bukkit.getOperators();
            ObjectArrayList sendTargets = new ObjectArrayList();
            if (forwardTarget == null) {
                serverOps.forEach(offlinePlayer -> {
                    Player onlinePlayer = offlinePlayer.getPlayer();
                    if (onlinePlayer != null && onlinePlayer.hasPermission("feathermorph.check_update")) {
                        sendTargets.add((Object)onlinePlayer);
                    }
                });
            } else if (!(forwardTarget instanceof ServerCommandSender) && !(forwardTarget instanceof ConsoleCommandSender)) {
                sendTargets.add((Object)forwardTarget);
            }
            sendTargets.add((Object)Bukkit.getConsoleSender());
            this.msgPrimary = UpdateStrings.newVersionAvailable().resolve("current", currentVersion.toString()).resolve("origin", latestVersion.toString());
            this.msgSecondary = UpdateStrings.update_here().resolve("url", "https://modrinth.com/plugin/feathermorph");
            this.updateAvailable = true;
            if (sendMessages) {
                for (CommandSender sendTarget : sendTargets) {
                    this.sendUpdateNotifyTo(sendTarget);
                }
            }
            return CheckResult.HAS_UPDATE;
        }
        catch (Throwable t) {
            this.logger.error("Error occurred while processing response", t);
            return CheckResult.FAIL;
        }
    }

    public boolean updateAvailable() {
        return this.updateAvailable;
    }

    public void sendUpdateNotifyTo(CommandSender sendTarget) {
        if (!this.updateAvailable) {
            sendTarget.sendMessage(MessageUtils.prefixes(sendTarget, this.noNewVersionAvailable));
            return;
        }
        assert (this.msgPrimary != null);
        assert (this.msgSecondary != null);
        sendTarget.sendMessage(MessageUtils.prefixes(sendTarget, this.messageHeaderFooter));
        sendTarget.sendMessage(MessageUtils.prefixes(sendTarget, this.msgPrimary));
        sendTarget.sendMessage(MessageUtils.prefixes(sendTarget, this.msgSecondary));
        sendTarget.sendMessage(MessageUtils.prefixes(sendTarget, this.messageHeaderFooter));
    }

    public static enum CheckResult {
        HAS_UPDATE,
        ALREADY_LATEST,
        NOT_LISTED_OR_UNSUPPORTED,
        CURRENT_IS_NEWER,
        FAIL;

    }

    private static class InvalidOperationException
    extends RuntimeException {
        public InvalidOperationException() {
        }

        public InvalidOperationException(String message) {
            super(message);
        }

        public InvalidOperationException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidOperationException(Throwable cause) {
            super(cause);
        }
    }
}

