/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.commands.data.EntityDataAccessor;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.utilities.EntityTypeUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class NbtUtils {
    public static List<String> defaultBlacklistedPatterns = List.of("[pP]urpur.*", "[pP]aper.*", "[sS]pigot.*", "[bB]ukkit.*", "Xp.*", "food.*", "Death.*", "Spawn.*");
    public static List<String> defaultBlacklistedTags = List.of("UUID", "data", "Brain", "Motion", "palette", "Attributes", "Invulnerable", "DisabledSlots", "ArmorItems", "HandItems", "Tags", "recipes", "Inventory", "abilities", "recipeBook", "EnderItems", "warden_spawn_tracker", "previousPlayerGameType", "LastDeathLocation", "playerGameType", "seenCredits", "Score", "Offers", "LastRestock", "RestocksToday", "Pos", "Owner", "WorldUUIDLeast", "WorldUUIDMost", "Rotation", "listener", "ActiveEffects", "ArmorDropChances", "PersistenceRequired", "SelectedItem");

    @Nullable
    public static UUID readUUID(@Nullable Tag element) {
        Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
        if (element == null) {
            return null;
        }
        if (!element.getType().equals((Object)IntArrayTag.TYPE)) {
            logger.warn("Given element is not a int array, can't convert to UUID");
            return null;
        }
        int[] is = ((IntArrayTag)element).getAsIntArray();
        if (is.length != 4) {
            logger.warn("Given int array is not of length 4, can't convert to UUID");
            return null;
        }
        return UUIDUtil.uuidFromIntArray((int[])is);
    }

    public static void putUUID(CompoundTag nbt, String key, UUID uuid) {
        int[] array = UUIDUtil.uuidToIntArray((UUID)uuid);
        IntArrayTag tag = new IntArrayTag(array);
        nbt.put(key, (Tag)tag);
    }

    public static CompoundTag writeGameProfile(CompoundTag nbt, GameProfile profile) {
        if (!profile.name().isEmpty()) {
            nbt.putString("Name", profile.name());
        }
        if (!profile.id().equals(Uuids.NIL_UUID)) {
            NbtUtils.putUUID(nbt, "Id", profile.id());
        }
        if (profile.properties().isEmpty()) {
            return nbt;
        }
        CompoundTag propertiesCompound = new CompoundTag();
        for (String key : profile.properties().keySet()) {
            if (key == null) continue;
            ListTag list = new ListTag();
            for (Property property : profile.properties().get((Object)key)) {
                if (property == null) continue;
                CompoundTag childCompound = new CompoundTag();
                childCompound.putString("Value", property.value());
                String sign = property.signature();
                if (sign != null) {
                    childCompound.putString("Signature", sign);
                }
                list.add((Object)childCompound);
            }
            propertiesCompound.put(key, (Tag)list);
        }
        nbt.put("Properties", (Tag)propertiesCompound);
        return nbt;
    }

    @javax.annotation.Nullable
    public static GameProfile readGameProfile(String snbt) {
        Tag tag2;
        UUID readUUID;
        CompoundTag compound = null;
        try {
            compound = TagParser.parseCompoundFully((String)snbt);
        }
        catch (Throwable t) {
            Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
            logger.warn("Unable to parse GameProfile: " + t.getMessage());
            logger.warn("Raw profile: '%s'".formatted(snbt));
            return null;
        }
        String name = "NIL";
        if (compound.contains("Name")) {
            name = (String)compound.getString("Name").orElseThrow();
        }
        UUID uuid = Uuids.NIL_UUID;
        if (compound.contains("Id") && (readUUID = NbtUtils.readUUID(tag2 = compound.get("Id"))) != null) {
            uuid = readUUID;
        }
        if (!compound.contains("Properties")) {
            return new GameProfile(uuid, name);
        }
        try {
            CompoundTag propertiesCompound = (CompoundTag)compound.getCompound("Properties").orElseThrow();
            ImmutableMultimap.Builder propertiesBuilder = ImmutableMultimap.builder();
            propertiesCompound.forEach((key, tag) -> {
                ListTag list = propertiesCompound.getListOrEmpty(key);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag childCompound = list.getCompound(i).orElse(null);
                    if (childCompound == null) continue;
                    String value = (String)childCompound.getString("Value").orElseThrow();
                    if (childCompound.contains("Signature")) {
                        propertiesBuilder.put(key, (Object)new Property(key, value, (String)childCompound.getString("Signature").orElseThrow()));
                        continue;
                    }
                    propertiesBuilder.put(key, (Object)new Property(key, value));
                }
            });
            return new GameProfile(uuid, name, new PropertyMap((Multimap)propertiesBuilder.build()));
        }
        catch (Throwable t) {
            Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
            logger.warn("Can't parse profile properties", t);
            return null;
        }
    }

    public static CompoundTag toCompoundTag(GameProfile profile) {
        CompoundTag compound = new CompoundTag();
        return NbtUtils.writeGameProfile(compound, profile);
    }

    @NotNull
    public static CompoundTag getRawTagCompound(Entity entity) {
        if (entity instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)entity;
            net.minecraft.world.entity.Entity nmsEntity = craftEntity.getHandle();
            EntityDataAccessor entityDataObject = new EntityDataAccessor(nmsEntity);
            return entityDataObject.getData();
        }
        return new CompoundTag();
    }

    public static String getCompoundString(CompoundTag compound) {
        if (compound == null) {
            return null;
        }
        StringTagVisitor visitor = new StringTagVisitor();
        visitor.visitCompound(compound);
        return visitor.build();
    }

    @Nullable
    public static CompoundTag toCompoundTag(@Nullable String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        try {
            return TagParser.parseCompoundFully((String)input);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    @Contract(value="_, false -> !null; _, true -> _")
    public static CompoundTag toCompoundTag(@Nullable String input, boolean nullIfInvalid) {
        CompoundTag result = NbtUtils.toCompoundTag(input);
        if (result != null) {
            return result;
        }
        return nullIfInvalid ? null : new CompoundTag();
    }

    public static boolean isBabyForType(EntityType type, CompoundTag compoundTag) {
        boolean ageable = EntityTypeUtils.hasBabyVariant(type);
        if (!ageable) {
            return false;
        }
        if (EntityTypeUtils.isZombie(type) || type == EntityType.PIGLIN) {
            return compoundTag.getBoolean("IsBaby").orElse(false);
        }
        Integer val = compoundTag.getInt("Age").orElse(1);
        return val < 0;
    }
}

