/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityDimensions;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;

public class ReflectionUtils {
    private static final Map<ServerPlayer, Field> playerDimensionFieldMap = new Object2ObjectOpenHashMap();
    private static final String dimensionsFieldName = "dimensions";
    private static final String playerEyeHeightFieldName = "eyeHeight";
    private static final Map<ServerPlayer, Field> playerEHFieldMap = new Object2ObjectOpenHashMap();

    public static void cleanCaches() {
        ObjectArrayList toRemove = new ObjectArrayList();
        playerDimensionFieldMap.forEach((s, f) -> {
            if (!s.getBukkitEntity().isOnline()) {
                toRemove.add(s);
            }
        });
        playerEHFieldMap.forEach((s, f) -> {
            if (!s.getBukkitEntity().isOnline()) {
                toRemove.add(s);
            }
        });
        for (ServerPlayer serverPlayer : toRemove) {
            playerDimensionFieldMap.remove(serverPlayer);
            playerEHFieldMap.remove(serverPlayer);
        }
    }

    public static Field getPlayerDimensionsField(ServerPlayer player) throws NullDependencyException {
        Field field = playerDimensionFieldMap.getOrDefault(player, null);
        if (field != null) {
            return field;
        }
        field = ReflectionUtils.getFields(player, EntityDimensions.class, true).stream().filter(f -> !Modifier.isStatic(f.getModifiers()) && f.getName().equals(dimensionsFieldName)).findFirst().orElse(null);
        if (field == null) {
            throw new NullDependencyException("Unable to find player dimension: No such field 'EntitySize %s'".formatted(dimensionsFieldName));
        }
        playerDimensionFieldMap.put(player, field);
        field.setAccessible(true);
        return field;
    }

    public static <T> T getValue(Object obj, String fieldName, Class<T> type) throws NullDependencyException {
        return ReflectionUtils.getValue(obj, fieldName, type, true);
    }

    public static <T> T getValue(Object obj, String fieldName, Class<T> type, boolean includeBaseClasses) throws NullDependencyException {
        List<Field> fields = ReflectionUtils.getFields(obj, type, true);
        Field targetField = null;
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            targetField = field;
            break;
        }
        if (targetField == null) {
            throw new NullDependencyException("Field '%s' with type '%s' not found in '%s'".formatted(fieldName, type, obj));
        }
        targetField.setAccessible(true);
        try {
            Object value = targetField.get(obj);
            return (T)value;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Field getPlayerEyeHeightField(ServerPlayer player) throws NullDependencyException {
        Field field = playerEHFieldMap.getOrDefault(player, null);
        if (field != null) {
            return field;
        }
        field = ReflectionUtils.getFields(player, Float.TYPE, true).stream().filter(f -> !Modifier.isStatic(f.getModifiers()) && Modifier.isPrivate(f.getModifiers()) && f.getName().equals(playerEyeHeightFieldName)).findFirst().orElse(null);
        if (field == null) {
            throw new NullDependencyException("Unable to find player eye height: No such field 'EntitySize %s'".formatted(playerEyeHeightFieldName));
        }
        field.setAccessible(true);
        playerEHFieldMap.put(player, field);
        return field;
    }

    public static List<Field> getFields(Object obj, Class<?> type, boolean searchBaseClass) {
        Class<?> clazz = obj.getClass();
        ObjectArrayList fields = new ObjectArrayList();
        ReflectionUtils.searchFields(clazz, (List<Field>)fields);
        return fields.stream().filter(f -> f.getType() == type).toList();
    }

    private static void searchFields(Class<?> clazz, List<Field> fields) {
        fields.addAll(Arrays.stream(clazz.getDeclaredFields()).toList());
        if (clazz.getSuperclass() != null) {
            ReflectionUtils.searchFields(clazz.getSuperclass(), fields);
        }
    }
}

