/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.converter;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SAnimationCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SInitialCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SMorphCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SOptionCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SRequestCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SSkillCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SToggleSelfCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SUnmorphCommand;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SActivateSkillCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SExchangeRequestManagementCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SMorphCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SRequestAnimationCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SRequestInitialCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SSetSingleOptionCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SToggleSelfCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SUnmorphCommand;

public class C2SCommandConverter {
    private final Map<String, Function<AbstractC2SCommand<?>, NetheriteC2SCommand<?>>> c2sFromModernToNetherite = new ConcurrentHashMap();
    private final Map<String, Function<NetheriteC2SCommand<?>, AbstractC2SCommand<?>>> fromNetheriteToModernConverts = new ConcurrentHashMap();

    public C2SCommandConverter() {
        this.registerC2SModernToNetherite();
        this.registerFromNetheriteToModernMethods();
    }

    public <X extends AbstractC2SCommand<?>> void registerC2SFromModernToNetherite(String cmdName, Class<X> expectedClass, Function<X, NetheriteC2SCommand<?>> method) {
        Function<AbstractC2SCommand, NetheriteC2SCommand> mth = modernCommand -> {
            if (!expectedClass.isInstance(modernCommand)) {
                throw new IllegalArgumentException("Input command '%s' is not expected type '%s'".formatted(modernCommand.getClass().getSimpleName(), expectedClass.getSimpleName()));
            }
            return (NetheriteC2SCommand)method.apply(modernCommand);
        };
        this.c2sFromModernToNetherite.put(cmdName, mth);
    }

    protected void registerC2SModernToNetherite() {
        this.registerC2SFromModernToNetherite("request_initial", C2SRequestInitialCommand.class, cmd -> new NetheriteC2SInitialCommand());
        this.registerC2SFromModernToNetherite("request_animation", C2SRequestAnimationCommand.class, cmd -> new NetheriteC2SAnimationCommand(cmd.getAnimationId()));
        this.registerC2SFromModernToNetherite("morph", C2SMorphCommand.class, cmd -> {
            String id = cmd.identifier();
            return new NetheriteC2SMorphCommand(id);
        });
        this.registerC2SFromModernToNetherite("set_single_option", C2SSetSingleOptionCommand.class, cmd -> {
            C2SSetSingleOptionCommand.ClientOptionEnum optionModern = cmd.getOption();
            NetheriteC2SOptionCommand.ClientOptions optionNetherite = switch (optionModern) {
                default -> throw new IncompatibleClassChangeError();
                case C2SSetSingleOptionCommand.ClientOptionEnum.HUD -> NetheriteC2SOptionCommand.ClientOptions.HUD;
                case C2SSetSingleOptionCommand.ClientOptionEnum.CLIENTVIEW -> NetheriteC2SOptionCommand.ClientOptions.CLIENTVIEW;
            };
            return new NetheriteC2SOptionCommand(optionNetherite).setValue(cmd.getValue());
        });
        this.registerC2SFromModernToNetherite("skill", C2SActivateSkillCommand.class, cmd -> new NetheriteC2SSkillCommand());
        this.registerC2SFromModernToNetherite("set_selfview_mode", C2SToggleSelfCommand.class, cmd -> {
            C2SToggleSelfCommand.SelfViewMode modeModern = cmd.getSelfViewMode();
            NetheriteC2SToggleSelfCommand.SelfViewMode modeNetherite = switch (modeModern) {
                default -> throw new IncompatibleClassChangeError();
                case C2SToggleSelfCommand.SelfViewMode.ON -> NetheriteC2SToggleSelfCommand.SelfViewMode.ON;
                case C2SToggleSelfCommand.SelfViewMode.OFF -> NetheriteC2SToggleSelfCommand.SelfViewMode.OFF;
                case C2SToggleSelfCommand.SelfViewMode.CLIENT_ON -> NetheriteC2SToggleSelfCommand.SelfViewMode.CLIENT_ON;
                case C2SToggleSelfCommand.SelfViewMode.CLIENT_OFF -> NetheriteC2SToggleSelfCommand.SelfViewMode.CLIENT_OFF;
            };
            return new NetheriteC2SToggleSelfCommand(modeNetherite);
        });
        this.registerC2SFromModernToNetherite("unmorph", C2SUnmorphCommand.class, cmd -> new NetheriteC2SUnmorphCommand());
        this.registerC2SFromModernToNetherite("manage_request", C2SExchangeRequestManagementCommand.class, cmd -> {
            C2SExchangeRequestManagementCommand.Decision modernDecision = cmd.decision;
            NetheriteC2SRequestCommand.Decision netheriteDecision = switch (modernDecision) {
                default -> throw new IncompatibleClassChangeError();
                case C2SExchangeRequestManagementCommand.Decision.ACCEPT -> NetheriteC2SRequestCommand.Decision.ACCEPT;
                case C2SExchangeRequestManagementCommand.Decision.DENY -> NetheriteC2SRequestCommand.Decision.DENY;
                case C2SExchangeRequestManagementCommand.Decision.UNKNOWN -> NetheriteC2SRequestCommand.Decision.UNKNOWN;
            };
            return new NetheriteC2SRequestCommand(netheriteDecision, cmd.targetRequestName);
        });
    }

    public NetheriteC2SCommand<?> toNetheriteCommand(AbstractC2SCommand<?> modernCommand) throws RuntimeException {
        Function convertMethod = this.c2sFromModernToNetherite.getOrDefault(modernCommand.getBaseName(), null);
        if (convertMethod == null) {
            throw new RuntimeException("No convert method found for input command %s".formatted(modernCommand.getBaseName()));
        }
        return (NetheriteC2SCommand)convertMethod.apply(modernCommand);
    }

    private <X extends NetheriteC2SCommand<?>> C2SCommandConverter registerNetheriteToModern(String cmdName, Class<X> expectedClass, Function<X, AbstractC2SCommand<?>> method) {
        Function<NetheriteC2SCommand, AbstractC2SCommand> mth = netheriteCommand -> {
            if (!expectedClass.isInstance(netheriteCommand)) {
                throw new IllegalArgumentException("Input command '%s' is not expected type '%s'".formatted(netheriteCommand.getClass().getSimpleName(), expectedClass.getSimpleName()));
            }
            return (AbstractC2SCommand)method.apply(netheriteCommand);
        };
        this.fromNetheriteToModernConverts.put(cmdName, mth);
        return this;
    }

    protected void registerFromNetheriteToModernMethods() {
        this.registerNetheriteToModern("animation", NetheriteC2SAnimationCommand.class, cmd -> {
            String animId = cmd.getAnimationId();
            return new C2SRequestAnimationCommand(animId);
        }).registerNetheriteToModern("initial", NetheriteC2SInitialCommand.class, cmd -> new C2SRequestInitialCommand()).registerNetheriteToModern("morph", NetheriteC2SMorphCommand.class, cmd -> {
            String id = cmd.getArgumentAt(0, "");
            return new C2SMorphCommand(id, Collections.emptyMap());
        }).registerNetheriteToModern("option", NetheriteC2SOptionCommand.class, cmd -> {
            NetheriteC2SOptionCommand.ClientOptions option = cmd.getOption();
            String value = cmd.getValue();
            C2SSetSingleOptionCommand.ClientOptionEnum optionEnum = switch (option) {
                default -> throw new IncompatibleClassChangeError();
                case NetheriteC2SOptionCommand.ClientOptions.CLIENTVIEW -> C2SSetSingleOptionCommand.ClientOptionEnum.CLIENTVIEW;
                case NetheriteC2SOptionCommand.ClientOptions.HUD -> C2SSetSingleOptionCommand.ClientOptionEnum.HUD;
            };
            return new C2SSetSingleOptionCommand(optionEnum, value);
        }).registerNetheriteToModern("request", NetheriteC2SRequestCommand.class, cmd -> {
            C2SExchangeRequestManagementCommand.Decision decision = switch (cmd.decision) {
                default -> throw new IncompatibleClassChangeError();
                case NetheriteC2SRequestCommand.Decision.ACCEPT -> C2SExchangeRequestManagementCommand.Decision.ACCEPT;
                case NetheriteC2SRequestCommand.Decision.DENY -> C2SExchangeRequestManagementCommand.Decision.DENY;
                case NetheriteC2SRequestCommand.Decision.UNKNOWN -> C2SExchangeRequestManagementCommand.Decision.UNKNOWN;
            };
            return new C2SExchangeRequestManagementCommand(decision, cmd.targetRequestName);
        }).registerNetheriteToModern("skill", NetheriteC2SSkillCommand.class, cmd -> new C2SActivateSkillCommand()).registerNetheriteToModern("toggleself", NetheriteC2SToggleSelfCommand.class, cmd -> {
            C2SToggleSelfCommand.SelfViewMode mode = switch (cmd.getSelfViewMode()) {
                default -> throw new IncompatibleClassChangeError();
                case NetheriteC2SToggleSelfCommand.SelfViewMode.ON -> C2SToggleSelfCommand.SelfViewMode.ON;
                case NetheriteC2SToggleSelfCommand.SelfViewMode.OFF -> C2SToggleSelfCommand.SelfViewMode.OFF;
                case NetheriteC2SToggleSelfCommand.SelfViewMode.CLIENT_ON -> C2SToggleSelfCommand.SelfViewMode.CLIENT_ON;
                case NetheriteC2SToggleSelfCommand.SelfViewMode.CLIENT_OFF -> C2SToggleSelfCommand.SelfViewMode.CLIENT_OFF;
            };
            return new C2SToggleSelfCommand(mode);
        }).registerNetheriteToModern("unmorph", NetheriteC2SUnmorphCommand.class, cmd -> new C2SUnmorphCommand());
    }

    public AbstractC2SCommand<?> fromNetheriteCommand(NetheriteC2SCommand<?> netheriteCommand) throws RuntimeException {
        Function convertMethod = this.fromNetheriteToModernConverts.getOrDefault(netheriteCommand.getBaseName(), null);
        if (convertMethod == null) {
            throw new RuntimeException("No convert method found for input command %s".formatted(netheriteCommand.getBaseName()));
        }
        return (AbstractC2SCommand)convertMethod.apply(netheriteCommand);
    }
}

