/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.converter;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CAnimationCommand;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CCommand;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CCurrentCommand;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CReAuthCommand;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CRequestCommand;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CSwapCommand;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CUnAuthCommand;
import xyz.nifeather.fmccl.network.commands.S2C.clientrender.NetheriteEquipment;
import xyz.nifeather.fmccl.network.commands.S2C.clientrender.NetheriteS2CRenderMapAddCommand;
import xyz.nifeather.fmccl.network.commands.S2C.clientrender.NetheriteS2CRenderMapClearCommand;
import xyz.nifeather.fmccl.network.commands.S2C.clientrender.NetheriteS2CRenderMapMetaCommand;
import xyz.nifeather.fmccl.network.commands.S2C.clientrender.NetheriteS2CRenderMapRemoveCommand;
import xyz.nifeather.fmccl.network.commands.S2C.clientrender.NetheriteS2CRenderMapSyncCommand;
import xyz.nifeather.fmccl.network.commands.S2C.clientrender.NetheriteS2CRenderMeta;
import xyz.nifeather.fmccl.network.commands.S2C.map.NetheriteS2CMapClearCommand;
import xyz.nifeather.fmccl.network.commands.S2C.map.NetheriteS2CMapCommand;
import xyz.nifeather.fmccl.network.commands.S2C.map.NetheriteS2CMapRemoveCommand;
import xyz.nifeather.fmccl.network.commands.S2C.map.NetheriteS2CPartialMapCommand;
import xyz.nifeather.fmccl.network.commands.S2C.query.NetheriteQueryType;
import xyz.nifeather.fmccl.network.commands.S2C.query.NetheriteS2CQueryCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetAggressiveCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetAnimationDisplayNameCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetAvailableAnimationsCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetDisplayingFakeEquipCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetModifyBoundingBoxCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetProfileCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetRevealingCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetSNbtCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetSelfViewingCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetSkillCooldownCommand;
import xyz.nifeather.fmccl.network.commands.S2C.set.NetheriteS2CSetSneakingCommand;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CPlayAnimationCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CReAuthCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CSetCurrentCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CSwapCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CUnAuthCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CUpdateRequestStatusCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CAddAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CClearAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CRemoveAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CSyncAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.Equipment;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRClearCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSetMetaCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRSyncRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRUnregisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CRenderMeta;
import xyz.nifeather.morph.network.commands.S2C.query.QueryType;
import xyz.nifeather.morph.network.commands.S2C.query.S2CQueryCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAggressiveCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAnimationDisplayNameCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAvailableAnimationsCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetDisplayingFakeEquipCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetMobRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetModifyBoundingBoxCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetProfileCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSNbtCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSelfViewingStatusCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSkillCooldownCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSneakingCommand;

public abstract class S2CCommandConverter {
    private final Map<String, Function<AbstractS2CCommand<?>, NetheriteS2CCommand<?>>> fromModernToNetherite = new ConcurrentHashMap();
    private final Map<String, Function<NetheriteS2CCommand<?>, AbstractS2CCommand<?>>> fromNetheriteToModern = new ConcurrentHashMap();

    public S2CCommandConverter() {
        this.registerFromModernToNetherite();
        this.registerFromNetheriteToModern();
        this.registerFakeEquipCommandConversions();
    }

    protected abstract void registerFakeEquipCommandConversions();

    public <X extends AbstractS2CCommand<?>> S2CCommandConverter registerModernToNetherite(String cmdName, Class<X> expectedClass, Function<X, NetheriteS2CCommand<?>> method) {
        Function<AbstractS2CCommand, NetheriteS2CCommand> mth = modernCommand -> {
            if (!expectedClass.isInstance(modernCommand)) {
                throw new IllegalArgumentException("Input command '%s' is not expected type '%s'".formatted(modernCommand.getClass().getSimpleName(), expectedClass.getSimpleName()));
            }
            return (NetheriteS2CCommand)method.apply(modernCommand);
        };
        this.fromModernToNetherite.put(cmdName, mth);
        return this;
    }

    protected void registerFromModernToNetherite() {
        this.registerModernToNetherite("set_current", S2CSetCurrentCommand.class, cmd -> new NetheriteS2CCurrentCommand(cmd.getDisguiseIdentifier())).registerModernToNetherite("reauth", S2CReAuthCommand.class, cmd -> new NetheriteS2CReAuthCommand()).registerModernToNetherite("unauth", S2CUnAuthCommand.class, cmd -> new NetheriteS2CUnAuthCommand()).registerModernToNetherite("action_swap_hand", S2CSwapCommand.class, cmd -> new NetheriteS2CSwapCommand()).registerModernToNetherite("query", S2CQueryCommand.class, cmd -> {
            QueryType type = cmd.queryType();
            List<String> diff = cmd.getDiff();
            NetheriteQueryType netheriteType = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case QueryType.UNKNOWN -> NetheriteQueryType.UNKNOWN;
                case QueryType.ADD -> NetheriteQueryType.ADD;
                case QueryType.REMOVE -> NetheriteQueryType.REMOVE;
                case QueryType.SET -> NetheriteQueryType.SET;
            };
            return new NetheriteS2CQueryCommand(netheriteType, (String[])diff.toArray(String[]::new));
        }).registerModernToNetherite("update_request_status", S2CUpdateRequestStatusCommand.class, cmd -> {
            S2CUpdateRequestStatusCommand.Type requestType = cmd.requestType;
            String targetName = cmd.source;
            NetheriteS2CRequestCommand.NetheriteRequestType netheriteRequestType = switch (requestType) {
                default -> throw new IncompatibleClassChangeError();
                case S2CUpdateRequestStatusCommand.Type.Unknown -> NetheriteS2CRequestCommand.NetheriteRequestType.Unknown;
                case S2CUpdateRequestStatusCommand.Type.NewRequest -> NetheriteS2CRequestCommand.NetheriteRequestType.NewRequest;
                case S2CUpdateRequestStatusCommand.Type.RequestSend -> NetheriteS2CRequestCommand.NetheriteRequestType.RequestSend;
                case S2CUpdateRequestStatusCommand.Type.RequestExpired -> NetheriteS2CRequestCommand.NetheriteRequestType.RequestExpired;
                case S2CUpdateRequestStatusCommand.Type.RequestExpiredOwner -> NetheriteS2CRequestCommand.NetheriteRequestType.RequestExpiredOwner;
                case S2CUpdateRequestStatusCommand.Type.RequestAccepted -> NetheriteS2CRequestCommand.NetheriteRequestType.RequestAccepted;
                case S2CUpdateRequestStatusCommand.Type.RequestDenied -> NetheriteS2CRequestCommand.NetheriteRequestType.RequestDenied;
            };
            return new NetheriteS2CRequestCommand(netheriteRequestType, targetName);
        }).registerModernToNetherite("set_aggressive", S2CSetAggressiveCommand.class, cmd -> new NetheriteS2CSetAggressiveCommand(cmd.val)).registerModernToNetherite("set_skin_profile", S2CSetProfileCommand.class, cmd -> new NetheriteS2CSetProfileCommand(cmd.getProfileSNbt())).registerModernToNetherite("set_skill_cooldown", S2CSetSkillCooldownCommand.class, cmd -> new NetheriteS2CSetSkillCooldownCommand(cmd.val)).registerModernToNetherite("set_nbt", S2CSetSNbtCommand.class, cmd -> new NetheriteS2CSetSNbtCommand(cmd.getSNbt())).registerModernToNetherite("set_sneaking", S2CSetSneakingCommand.class, cmd -> new NetheriteS2CSetSneakingCommand(cmd.sneaking)).registerModernToNetherite("set_clientview_enabled", S2CSetSelfViewingStatusCommand.class, cmd -> new NetheriteS2CSetSelfViewingCommand(cmd.selfViewing())).registerModernToNetherite("set_boundingbox_modify_status", S2CSetModifyBoundingBoxCommand.class, cmd -> new NetheriteS2CSetModifyBoundingBoxCommand(cmd.getModifyBoundingBox())).registerModernToNetherite("set_mob_reveal", S2CSetMobRevealCommand.class, cmd -> new NetheriteS2CSetRevealingCommand(cmd.getValue())).registerModernToNetherite("set_avail_anim", S2CSetAvailableAnimationsCommand.class, cmd -> new NetheriteS2CSetAvailableAnimationsCommand(cmd.getAvailableAnimations())).registerModernToNetherite("set_anim_display", S2CSetAnimationDisplayNameCommand.class, cmd -> new NetheriteS2CSetAnimationDisplayNameCommand(cmd.getDisplayIdentifier())).registerModernToNetherite("set_displaying_fake_equip", S2CSetDisplayingFakeEquipCommand.class, cmd -> new NetheriteS2CSetDisplayingFakeEquipCommand(cmd.displaying));
        this.registerModernToNetherite("admin_reveal_sync", S2CSyncAdminRevealCommand.class, cmd -> new NetheriteS2CMapCommand(cmd.getMap())).registerModernToNetherite("admin_reveal_add", S2CAddAdminRevealCommand.class, cmd -> new NetheriteS2CPartialMapCommand(cmd.getMap())).registerModernToNetherite("admin_reveal_remove", S2CRemoveAdminRevealCommand.class, cmd -> new NetheriteS2CMapRemoveCommand(cmd.getTargetId())).registerModernToNetherite("admin_reveal_clear", S2CClearAdminRevealCommand.class, cmd -> new NetheriteS2CMapClearCommand());
        this.registerModernToNetherite("play_animation", S2CPlayAnimationCommand.class, cmd -> new NetheriteS2CAnimationCommand(cmd.getAnimId()));
        this.registerModernToNetherite("cr_syncrender", S2CCRSyncRegisterCommand.class, cmd -> new NetheriteS2CRenderMapSyncCommand(cmd.getMap())).registerModernToNetherite("cr_add", S2CCRRegisterCommand.class, cmd -> new NetheriteS2CRenderMapAddCommand(cmd.getPlayerNetworkId(), cmd.getMobId())).registerModernToNetherite("cr_remove", S2CCRUnregisterCommand.class, cmd -> new NetheriteS2CRenderMapRemoveCommand(cmd.getPlayerNetworkId())).registerModernToNetherite("cr_clear", S2CCRClearCommand.class, cmd -> new NetheriteS2CRenderMapClearCommand()).registerModernToNetherite("cr_meta", S2CCRSetMetaCommand.class, cmd -> {
            S2CRenderMeta modernMeta = cmd.renderMeta;
            NetheriteS2CRenderMeta netheriteS2CRenderMeta = new NetheriteS2CRenderMeta(modernMeta.networkId);
            netheriteS2CRenderMeta.sNbt = modernMeta.sNbt;
            netheriteS2CRenderMeta.profileCompound = modernMeta.profileCompound;
            netheriteS2CRenderMeta.showOverridedEquipment = modernMeta.showOverridedEquipment;
            Equipment modernEquipment = modernMeta.overridedEquipment;
            if (modernEquipment != null) {
                NetheriteEquipment netheriteEquipment = new NetheriteEquipment();
                netheriteEquipment.headId = modernEquipment.headId;
                netheriteEquipment.headNbt = modernEquipment.headNbt;
                netheriteEquipment.chestId = modernEquipment.chestId;
                netheriteEquipment.chestNbt = modernEquipment.chestNbt;
                netheriteEquipment.leggingId = modernEquipment.leggingId;
                netheriteEquipment.leggingNbt = modernEquipment.leggingNbt;
                netheriteEquipment.feetId = modernEquipment.feetId;
                netheriteEquipment.feetNbt = modernEquipment.feetNbt;
                netheriteEquipment.handId = modernEquipment.handId;
                netheriteEquipment.handNbt = modernEquipment.handNbt;
                netheriteEquipment.offhandId = modernEquipment.offhandId;
                netheriteEquipment.offhandNbt = modernEquipment.offhandNbt;
                netheriteS2CRenderMeta.overridedEquipment = netheriteEquipment;
            }
            return new NetheriteS2CRenderMapMetaCommand(netheriteS2CRenderMeta);
        });
    }

    public NetheriteS2CCommand<?> toNetheriteCommand(AbstractS2CCommand<?> modernCommand) throws RuntimeException {
        Function convertMethod = this.fromModernToNetherite.getOrDefault(modernCommand.getBaseName(), null);
        if (convertMethod == null) {
            throw new RuntimeException("No convert method found for input command %s".formatted(modernCommand.getBaseName()));
        }
        return (NetheriteS2CCommand)convertMethod.apply(modernCommand);
    }

    public <X extends NetheriteS2CCommand<?>> S2CCommandConverter registerNetheriteToModern(String cmdName, Class<X> expectedClass, Function<X, AbstractS2CCommand<?>> method) {
        Function<NetheriteS2CCommand, AbstractS2CCommand> mth = modernCommand -> {
            if (!expectedClass.isInstance(modernCommand)) {
                throw new IllegalArgumentException("Input command '%s' is not expected type '%s'".formatted(modernCommand.getClass().getSimpleName(), expectedClass.getSimpleName()));
            }
            return (AbstractS2CCommand)method.apply(modernCommand);
        };
        this.fromNetheriteToModern.put(cmdName, mth);
        return this;
    }

    protected void registerFromNetheriteToModern() {
        this.registerNetheriteToModern("current", NetheriteS2CCurrentCommand.class, cmd -> {
            String id = cmd.getDisguiseIdentifier();
            return new S2CSetCurrentCommand("null".equals(id) ? null : id);
        }).registerNetheriteToModern("reauth", NetheriteS2CReAuthCommand.class, cmd -> new S2CReAuthCommand()).registerNetheriteToModern("unauth", NetheriteS2CUnAuthCommand.class, cmd -> new S2CUnAuthCommand()).registerNetheriteToModern("swap", NetheriteS2CSwapCommand.class, cmd -> new S2CSwapCommand()).registerNetheriteToModern("query", NetheriteS2CQueryCommand.class, cmd -> {
            NetheriteQueryType netheriteQueryType = cmd.queryType();
            List<String> diff = cmd.getDiff();
            QueryType netheriteType = switch (netheriteQueryType) {
                default -> throw new IncompatibleClassChangeError();
                case NetheriteQueryType.UNKNOWN -> QueryType.UNKNOWN;
                case NetheriteQueryType.ADD -> QueryType.ADD;
                case NetheriteQueryType.REMOVE -> QueryType.REMOVE;
                case NetheriteQueryType.SET -> QueryType.SET;
            };
            return new S2CQueryCommand(netheriteType, diff);
        }).registerNetheriteToModern("request", NetheriteS2CRequestCommand.class, cmd -> {
            NetheriteS2CRequestCommand.NetheriteRequestType netheriteRequestType = cmd.netheriteRequestType;
            String targetName = cmd.sourcePlayer;
            S2CUpdateRequestStatusCommand.Type requestType = switch (netheriteRequestType) {
                default -> throw new IncompatibleClassChangeError();
                case NetheriteS2CRequestCommand.NetheriteRequestType.Unknown -> S2CUpdateRequestStatusCommand.Type.Unknown;
                case NetheriteS2CRequestCommand.NetheriteRequestType.NewRequest -> S2CUpdateRequestStatusCommand.Type.NewRequest;
                case NetheriteS2CRequestCommand.NetheriteRequestType.RequestSend -> S2CUpdateRequestStatusCommand.Type.RequestSend;
                case NetheriteS2CRequestCommand.NetheriteRequestType.RequestExpired -> S2CUpdateRequestStatusCommand.Type.RequestExpired;
                case NetheriteS2CRequestCommand.NetheriteRequestType.RequestExpiredOwner -> S2CUpdateRequestStatusCommand.Type.RequestExpiredOwner;
                case NetheriteS2CRequestCommand.NetheriteRequestType.RequestAccepted -> S2CUpdateRequestStatusCommand.Type.RequestAccepted;
                case NetheriteS2CRequestCommand.NetheriteRequestType.RequestDenied -> S2CUpdateRequestStatusCommand.Type.RequestDenied;
            };
            return new S2CUpdateRequestStatusCommand(requestType, targetName);
        }).registerNetheriteToModern("aggressive", NetheriteS2CSetAggressiveCommand.class, cmd -> new S2CSetAggressiveCommand(cmd.getArgumentAt(0, false))).registerNetheriteToModern("profile", NetheriteS2CSetProfileCommand.class, cmd -> new S2CSetProfileCommand(cmd.getArgumentAt(0, "{}"))).registerNetheriteToModern("cd", NetheriteS2CSetSkillCooldownCommand.class, cmd -> new S2CSetSkillCooldownCommand(cmd.getArgumentAt(0, 0L))).registerNetheriteToModern("nbt", NetheriteS2CSetSNbtCommand.class, cmd -> new S2CSetSNbtCommand(cmd.getArgumentAt(0, "{}"))).registerNetheriteToModern("sneaking", NetheriteS2CSetSneakingCommand.class, cmd -> new S2CSetSneakingCommand(cmd.getArgumentAt(0, false))).registerNetheriteToModern("toggleself", NetheriteS2CSetSelfViewingCommand.class, cmd -> new S2CSetSelfViewingStatusCommand(cmd.getArgumentAt(0, false))).registerNetheriteToModern("boundingbox", NetheriteS2CSetModifyBoundingBoxCommand.class, cmd -> new S2CSetModifyBoundingBoxCommand(cmd.getModifyBoundingBox())).registerNetheriteToModern("reveal", NetheriteS2CSetRevealingCommand.class, cmd -> new S2CSetMobRevealCommand(cmd.getValue())).registerNetheriteToModern("avail_anim", NetheriteS2CSetAvailableAnimationsCommand.class, cmd -> new S2CSetAvailableAnimationsCommand(cmd.getAvailableAnimations())).registerNetheriteToModern("anim_display", NetheriteS2CSetAnimationDisplayNameCommand.class, cmd -> new S2CSetAnimationDisplayNameCommand(cmd.getDisplayIdentifier())).registerNetheriteToModern("fake_equip", NetheriteS2CSetDisplayingFakeEquipCommand.class, cmd -> new S2CSetDisplayingFakeEquipCommand(cmd.getArgumentAt(0, false)));
        this.registerNetheriteToModern("map", NetheriteS2CMapCommand.class, cmd -> new S2CSyncAdminRevealCommand(cmd.getMap())).registerNetheriteToModern("mapp", NetheriteS2CPartialMapCommand.class, cmd -> new S2CAddAdminRevealCommand(cmd.getMap())).registerNetheriteToModern("mapr", NetheriteS2CMapRemoveCommand.class, cmd -> new S2CRemoveAdminRevealCommand(cmd.getTargetId())).registerNetheriteToModern("mapc", NetheriteS2CMapClearCommand.class, cmd -> new S2CClearAdminRevealCommand());
        this.registerNetheriteToModern("animation", NetheriteS2CAnimationCommand.class, cmd -> new S2CPlayAnimationCommand(cmd.getAnimId()));
        this.registerNetheriteToModern("crm", NetheriteS2CRenderMapSyncCommand.class, cmd -> new S2CCRSyncRegisterCommand(cmd.getMap())).registerNetheriteToModern("cra", NetheriteS2CRenderMapAddCommand.class, cmd -> new S2CCRRegisterCommand(cmd.getPlayerNetworkId(), cmd.getMobId())).registerNetheriteToModern("crrm", NetheriteS2CRenderMapRemoveCommand.class, cmd -> new S2CCRUnregisterCommand(cmd.getPlayerNetworkId())).registerNetheriteToModern("crc", NetheriteS2CRenderMapClearCommand.class, cmd -> new S2CCRClearCommand()).registerNetheriteToModern("crmeta", NetheriteS2CRenderMapMetaCommand.class, cmd -> {
            NetheriteS2CRenderMeta netheriteMeta = (NetheriteS2CRenderMeta)cmd.getArgumentAt(0);
            S2CRenderMeta modernMeta = new S2CRenderMeta(netheriteMeta.networkId);
            modernMeta.sNbt = netheriteMeta.sNbt;
            modernMeta.profileCompound = netheriteMeta.profileCompound;
            modernMeta.showOverridedEquipment = netheriteMeta.showOverridedEquipment;
            NetheriteEquipment netheriteEquipment = netheriteMeta.overridedEquipment;
            if (netheriteEquipment != null) {
                Equipment modernEquipment = new Equipment();
                modernEquipment.headId = netheriteEquipment.headId;
                modernEquipment.headNbt = netheriteEquipment.headNbt;
                modernEquipment.chestId = netheriteEquipment.chestId;
                modernEquipment.chestNbt = netheriteEquipment.chestNbt;
                modernEquipment.leggingId = netheriteEquipment.leggingId;
                modernEquipment.leggingNbt = netheriteEquipment.leggingNbt;
                modernEquipment.feetId = netheriteEquipment.feetId;
                modernEquipment.feetNbt = netheriteEquipment.feetNbt;
                modernEquipment.handId = netheriteEquipment.handId;
                modernEquipment.handNbt = netheriteEquipment.handNbt;
                modernEquipment.offhandId = netheriteEquipment.offhandId;
                modernEquipment.offhandNbt = netheriteEquipment.offhandNbt;
                modernMeta.overridedEquipment = modernEquipment;
            }
            return new S2CCRSetMetaCommand(modernMeta);
        });
    }

    public AbstractS2CCommand<?> fromNetheriteCommand(NetheriteS2CCommand<?> netheriteCommand) throws RuntimeException {
        Function convertMethod = this.fromNetheriteToModern.getOrDefault(netheriteCommand.getBaseName(), null);
        if (convertMethod == null) {
            throw new RuntimeException("No convert method found for input command %s".formatted(netheriteCommand.getBaseName()));
        }
        return (AbstractS2CCommand)convertMethod.apply(netheriteCommand);
    }
}

