/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.interfaces.IManagePlayerData;
import xyz.nifeather.morph.interfaces.IManageRequests;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.RequestStrings;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.RequestInfo;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CUpdateRequestStatusCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class RequestManager
extends MorphPluginObject
implements IManageRequests {
    @Resolved
    private IManagePlayerData data;
    private final List<RequestInfo> requests = Collections.synchronizedList(new ObjectArrayList());
    @Resolved
    private MorphClientHandler clientHandler;

    @Initializer
    private void load() {
        this.addSchedule(this::update);
    }

    private void update() {
        this.addSchedule(this::update);
        if (this.requests.isEmpty()) {
            return;
        }
        ObjectArrayList requests = new ObjectArrayList(this.requests);
        for (RequestInfo r : requests) {
            --r.ticksRemain;
            if (r.ticksRemain > 0) continue;
            Player owner = r.sourcePlayer;
            if (r.ticksRemain > -255) {
                this.clientHandler.sendCommand(owner, (AbstractS2CCommand<?>)new S2CUpdateRequestStatusCommand(S2CUpdateRequestStatusCommand.Type.RequestExpiredOwner, r.targetPlayer.getName()));
                this.clientHandler.sendCommand(r.targetPlayer, (AbstractS2CCommand<?>)new S2CUpdateRequestStatusCommand(S2CUpdateRequestStatusCommand.Type.RequestExpired, owner.getName()));
            }
            this.requests.remove(r);
        }
    }

    @Override
    public void createRequest(Player source, Player target) {
        if (!source.hasPermission("feathermorph.request.send")) {
            MessageUtils.send((CommandSender)source, CommandStrings.noPermissionMessage());
            return;
        }
        if (this.requests.stream().anyMatch(i -> i.sourcePlayer.getUniqueId().equals(source.getUniqueId()) && i.targetPlayer.getUniqueId().equals(target.getUniqueId()))) {
            MessageUtils.send((CommandSender)source, RequestStrings.requestAlreadySentString().resolve("who", target.getName()));
            return;
        }
        RequestInfo req = new RequestInfo();
        req.sourcePlayer = source;
        req.targetPlayer = target;
        req.ticksRemain = 1200;
        this.requests.add(req);
        MessageUtils.send((CommandSender)target, RequestStrings.requestReceivedString().resolve("who", source.getName()));
        MessageUtils.send((CommandSender)target, RequestStrings.requestReceivedAcceptString().resolve("who", source.getName()));
        MessageUtils.send((CommandSender)target, RequestStrings.requestReceivedDenyString().resolve("who", source.getName()));
        MessageUtils.send((CommandSender)source, RequestStrings.requestSendString().resolve("who", target.getName()));
        this.clientHandler.sendCommand(target, (AbstractS2CCommand<?>)new S2CUpdateRequestStatusCommand(S2CUpdateRequestStatusCommand.Type.NewRequest, source.getName()));
        this.clientHandler.sendCommand(source, (AbstractS2CCommand<?>)new S2CUpdateRequestStatusCommand(S2CUpdateRequestStatusCommand.Type.RequestSend, target.getName()));
    }

    @Override
    public void acceptRequest(Player source, Player target) {
        if (!source.hasPermission("feathermorph.request.accept")) {
            MessageUtils.send((CommandSender)source, CommandStrings.noPermissionMessage());
            return;
        }
        RequestInfo req = this.requests.stream().filter(i -> i.sourcePlayer.getUniqueId().equals(target.getUniqueId()) && i.targetPlayer.getUniqueId().equals(source.getUniqueId())).findFirst().orElse(null);
        if (req == null) {
            MessageUtils.send((CommandSender)source, RequestStrings.requestNotFound());
            return;
        }
        req.ticksRemain = -256;
        this.data.grantMorphToPlayer(target, DisguiseTypes.PLAYER.toId(source.getName()));
        this.data.grantMorphToPlayer(source, DisguiseTypes.PLAYER.toId(target.getName()));
        MessageUtils.send((CommandSender)target, RequestStrings.targetAcceptedString().resolve("who", source.getName()));
        MessageUtils.send((CommandSender)source, RequestStrings.sourceAcceptedString().resolve("who", target.getName()));
        this.clientHandler.sendCommand(target, (AbstractS2CCommand<?>)new S2CUpdateRequestStatusCommand(S2CUpdateRequestStatusCommand.Type.RequestAccepted, source.getName()));
    }

    @Override
    public void denyRequest(Player source, Player target) {
        if (!source.hasPermission("feathermorph.request.deny")) {
            MessageUtils.send((CommandSender)source, CommandStrings.noPermissionMessage());
            return;
        }
        RequestInfo req = this.requests.stream().filter(i -> i.sourcePlayer.getUniqueId().equals(target.getUniqueId()) && i.targetPlayer.getUniqueId().equals(source.getUniqueId())).findFirst().orElse(null);
        if (req == null) {
            MessageUtils.send((CommandSender)source, RequestStrings.requestNotFound());
            return;
        }
        req.ticksRemain = -256;
        MessageUtils.send((CommandSender)target, RequestStrings.targetDeniedString().resolve("who", source.getName()));
        MessageUtils.send((CommandSender)source, RequestStrings.sourceDeniedString().resolve("who", target.getName()));
        this.clientHandler.sendCommand(target, (AbstractS2CCommand<?>)new S2CUpdateRequestStatusCommand(S2CUpdateRequestStatusCommand.Type.RequestDenied, source.getName()));
    }

    @Override
    public List<RequestInfo> getAvailableRequestsFor(Player player) {
        return this.requests.stream().filter(t -> t.targetPlayer.getUniqueId().equals(player.getUniqueId())).toList();
    }
}

