/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.abilities.MorphAbility;
import xyz.nifeather.morph.abilities.options.ReduceDamageOption;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public abstract class DamageReducingAbility<T extends ReduceDamageOption>
extends MorphAbility<T> {
    @Resolved
    private MorphManager morphs;

    protected abstract EntityDamageEvent.DamageCause getTargetCause();

    @Override
    public boolean handle(Player player, DisguiseState state) {
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTookDamage(EntityDamageEvent e) {
        Player player;
        Entity entity = e.getEntity();
        if (!(entity instanceof Player) || !this.isPlayerApplied(player = (Player)entity)) {
            return;
        }
        if (e.getCause() != this.getTargetCause()) {
            return;
        }
        DisguiseState state = this.morphs.getDisguiseStateFor(player);
        assert (state != null);
        ReduceDamageOption dmgOption = (ReduceDamageOption)this.getOptionFor(state);
        if (dmgOption == null) {
            return;
        }
        double damage = e.getDamage();
        boolean percentage = dmgOption.isPercentage();
        damage = percentage ? damage * (1.0 - dmgOption.getReduceAmount()) : damage - dmgOption.getReduceAmount();
        e.setDamage(Math.max(0.0, damage));
        if (damage <= 0.0) {
            e.setCancelled(true);
        }
    }
}

