/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;

public class PiglinWatcher
extends LivingEntityWatcher {
    public PiglinWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.PIGLIN);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.PIGLIN);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId = newVal.toString();
            Player player = this.getBindingPlayer();
            World world = player.getWorld();
            switch (animId) {
                case "dance_start": {
                    this.writePersistent(ValueIndex.PIGLIN.DANCING, true);
                    world.playSound(player.getLocation(), Sound.ENTITY_PIGLIN_CELEBRATE, 1.0f, 1.0f);
                    break;
                }
                case "stop": 
                case "reset": {
                    this.writePersistent(ValueIndex.PIGLIN.DANCING, false);
                }
            }
        }
    }
}

