/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.entity.villager.VillagerData;
import com.github.retrooper.packetevents.protocol.entity.villager.profession.VillagerProfession;
import com.github.retrooper.packetevents.protocol.entity.villager.profession.VillagerProfessions;
import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerType;
import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerTypes;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.VillagerProperties;
import xyz.nifeather.morph.utilities.MathUtils;

public class VillagerWatcher
extends LivingEntityWatcher {
    private VillagerProfession profession;
    private VillagerType type;
    private int lvl;

    public VillagerWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.VILLAGER);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.VILLAGER);
    }

    private VillagerData computeVillagerData() {
        VillagerProfession prof = this.profession == null ? VillagerProfessions.NONE : this.profession;
        VillagerType type = this.type == null ? VillagerTypes.PLAINS : this.type;
        return new VillagerData(type, prof, this.lvl);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        Villager.Type bukkitValue;
        VillagerProperties properties = DisguiseProperties.INSTANCE.getOrThrow(VillagerProperties.class);
        if (property.equals(properties.LEVEL)) {
            this.lvl = (Integer)value;
            this.writePersistent(ValueIndex.VILLAGER.VILLAGER_DATA, this.computeVillagerData());
        }
        if (property.equals(properties.TYPE)) {
            bukkitValue = (Villager.Type)value;
            this.type = Objects.requireNonNull(VillagerTypes.getByName((String)bukkitValue.key().asString()));
            this.writePersistent(ValueIndex.VILLAGER.VILLAGER_DATA, this.computeVillagerData());
        }
        if (property.equals(properties.PROFESSION)) {
            bukkitValue = (Villager.Profession)value;
            this.profession = Objects.requireNonNull(VillagerProfessions.getByName((String)bukkitValue.key().asString()));
            this.writePersistent(ValueIndex.VILLAGER.VILLAGER_DATA, this.computeVillagerData());
        }
        super.onPropertyWrite(property, value);
    }

    private void mergeFromVillagerData(CompoundTag nbt) {
        int level = 0;
        VillagerProfession profession = VillagerProfessions.NONE;
        VillagerType type = VillagerTypes.PLAINS;
        if (nbt.contains("level")) {
            level = MathUtils.clamp(1, 5, (Integer)nbt.getInt("level").orElseThrow());
        }
        if (nbt.contains("profession")) {
            String profString = (String)nbt.getString("profession").orElseThrow();
            VillagerProfession prof = VillagerProfessions.getByName((String)profString);
            if (prof == null) {
                this.logger.warn("No such profession '%s', using default".formatted(profString));
            } else {
                profession = prof;
            }
        }
        if (nbt.contains("type")) {
            String proftypeString = (String)nbt.getString("type").orElseThrow();
            VillagerType typeFromRegistry = VillagerTypes.getByName((String)proftypeString);
            if (typeFromRegistry == null) {
                this.logger.warn("No such type '%s', using default".formatted(proftypeString));
            } else {
                type = typeFromRegistry;
            }
        }
        this.writePersistent(ValueIndex.VILLAGER.VILLAGER_DATA, new VillagerData(type, profession, level));
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        VillagerData villagerData = this.read(ValueIndex.VILLAGER.VILLAGER_DATA);
        VillagerProfession profession = villagerData.getProfession();
        VillagerType type = villagerData.getType();
        int level = villagerData.getLevel();
        CompoundTag compound = new CompoundTag();
        compound.putInt("level", level);
        compound.putString("profession", profession.getName().toString());
        compound.putString("type", type.getName().toString());
        nbt.put("VillagerData", (Tag)compound);
    }
}

