/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityStatus;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.EHasAttackAnimationWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.BuildFailedException;

public class WardenWatcher
extends EHasAttackAnimationWatcher {
    public WardenWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.WARDEN);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        Player bindingPlayer = this.getBindingPlayer();
        if (entry.equals(CustomEntries.WARDEN_CHARGING_ATTACK) && Boolean.TRUE.equals(newVal)) {
            this.sendPacketToAffectedPlayers((PacketWrapper<?>)new WrapperPlayServerEntityStatus(this.getBindingPlayer().getEntityId(), 62));
        }
        if (entry.equals(CustomEntries.ANIMATION)) {
            String id = newVal.toString();
            World world = bindingPlayer.getWorld();
            switch (id) {
                case "roar": {
                    if (this.readEntryOrDefault(CustomEntries.WARDEN_VANISHED, false).booleanValue()) {
                        return;
                    }
                    this.block(ValueIndex.BASE_LIVING.POSE);
                    this.writePersistent(ValueIndex.BASE_LIVING.POSE, EntityPose.ROARING);
                    break;
                }
                case "roar_sound": {
                    if (this.readEntryOrDefault(CustomEntries.WARDEN_VANISHED, false).booleanValue()) {
                        return;
                    }
                    world.playSound(bindingPlayer.getLocation(), Sound.ENTITY_WARDEN_ROAR, SoundCategory.HOSTILE, 3.0f, 1.0f);
                    break;
                }
                case "sniff": {
                    if (this.readEntryOrDefault(CustomEntries.WARDEN_VANISHED, false).booleanValue()) {
                        return;
                    }
                    this.block(ValueIndex.BASE_LIVING.POSE);
                    this.writePersistent(ValueIndex.BASE_LIVING.POSE, EntityPose.SNIFFING);
                    world.playSound(bindingPlayer.getLocation(), Sound.ENTITY_WARDEN_SNIFF, SoundCategory.HOSTILE, 5.0f, 1.0f);
                    break;
                }
                case "digdown": {
                    if (this.readEntryOrDefault(CustomEntries.WARDEN_VANISHED, false).booleanValue()) {
                        return;
                    }
                    this.block(ValueIndex.BASE_LIVING.POSE);
                    this.writePersistent(ValueIndex.BASE_LIVING.POSE, EntityPose.DIGGING);
                    world.playSound(bindingPlayer.getLocation(), Sound.ENTITY_WARDEN_DIG, 5.0f, 1.0f);
                    break;
                }
                case "vanish": {
                    this.writePersistent(ValueIndex.BASE_ENTITY.GENERAL, (byte)32);
                    this.writePersistent(ValueIndex.BASE_LIVING.SILENT, true);
                    this.writePersistent(ValueIndex.BASE_LIVING.POSE, EntityPose.SLEEPING);
                    this.writeEntry(CustomEntries.WARDEN_VANISHED, true);
                    break;
                }
                case "appear": {
                    List<PacketWrapper<?>> packets;
                    this.writeEntry(CustomEntries.WARDEN_VANISHED, false);
                    this.block(ValueIndex.BASE_LIVING.POSE);
                    this.remove(ValueIndex.BASE_ENTITY.GENERAL);
                    this.writePersistent(ValueIndex.BASE_LIVING.POSE, EntityPose.EMERGING);
                    world.playSound(bindingPlayer.getLocation(), Sound.ENTITY_WARDEN_EMERGE, 5.0f, 1.0f);
                    try {
                        packets = this.buildSpawnPackets();
                    }
                    catch (BuildFailedException e) {
                        this.logger.error("Build spawn packet FAILED for Warden animate! not continuing", (Throwable)e);
                        this.reset();
                        return;
                    }
                    List<Player> affectedPlayers = this.getAffectedPlayers(bindingPlayer);
                    WrapperPlayServerDestroyEntities despawnPacket = new WrapperPlayServerDestroyEntities(bindingPlayer.getEntityId());
                    PlayerManager protocol = PacketEvents.getAPI().getPlayerManager();
                    for (Player affectedPlayer : affectedPlayers) {
                        protocol.sendPacket((Object)affectedPlayer, (PacketWrapper)despawnPacket);
                        packets.forEach(p -> protocol.sendPacket((Object)affectedPlayer, p));
                    }
                    break;
                }
                case "try_reset": {
                    if (this.readEntryOrDefault(CustomEntries.WARDEN_VANISHED, false).booleanValue()) {
                        return;
                    }
                    this.reset();
                    break;
                }
                case "reset": {
                    this.reset();
                }
            }
        }
        if (entry.equals(CustomEntries.IS_AGGRESSIVE)) {
            boolean aggressive = (Boolean)newVal;
            this.writeEntry(CustomEntries.WARDEN_CHARGING_ATTACK, aggressive);
        }
    }

    private void reset() {
        Player bindingPlayer = this.getBindingPlayer();
        this.writePersistent(ValueIndex.BASE_ENTITY.GENERAL, this.getPlayerBitMask(bindingPlayer));
        this.writePersistent(ValueIndex.BASE_LIVING.POSE, SpigotConversionUtil.fromBukkitPose((Pose)bindingPlayer.getPose()));
        this.writePersistent(ValueIndex.BASE_LIVING.SILENT, false);
        this.remove(ValueIndex.BASE_LIVING.POSE);
        this.remove(ValueIndex.BASE_ENTITY.GENERAL);
        this.remove(ValueIndex.BASE_LIVING.SILENT);
        this.unBlock(ValueIndex.BASE_LIVING.POSE);
    }
}

