/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Optional;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;

public class EnderDragonProperties
extends BaseLivingEntityProperties<EnderDragon> {
    public final SingleProperty<Integer> DRAGON_PHASE = this.createProperty("ender_dragon/dragon_phase", 10, this::readDragonPhase, OutputHandles::writeInteger);

    private Optional<Integer> readDragonPhase(String propertyName, String str) throws ParseErrorException {
        Integer val = InputHandles.readInteger(propertyName, str).orElseThrow(() -> new ParseErrorException(propertyName, "readDragonPhase: Unable to parse dragon phase"));
        InputHandles.throwIfOutOfBounds(propertyName, val, 0, 10);
        return Optional.of(val);
    }

    public EnderDragonProperties() {
        this.registerSingle((SingleProperty<?>)this.DRAGON_PHASE);
    }

    @Override
    @Nullable
    protected EnderDragon tryCastEntity(@Nullable Entity targetEntity) {
        EnderDragon enderDragon;
        return targetEntity instanceof EnderDragon ? (enderDragon = (EnderDragon)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull EnderDragon dragon) {
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
    }
}

