/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Parrot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class ParrotProperties
extends BaseLivingEntityProperties<Parrot> {
    private final Map<String, Parrot.Variant> variantMap = new ConcurrentHashMap<String, Parrot.Variant>();
    public final SingleProperty<Parrot.Variant> VARIANT = this.createProperty("parrot/variant", Parrot.Variant.RED, this::readVariant, OutputHandles::writeEnum).withRandom((Parrot.Variant[])Parrot.Variant.values());

    private void initMap() {
        for (Parrot.Variant variant : Parrot.Variant.values()) {
            this.variantMap.put(variant.name().toLowerCase(), variant);
        }
    }

    private Optional<Parrot.Variant> readVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])Parrot.Variant.values(), (String)propertyName, (String)string);
    }

    public ParrotProperties() {
        this.initMap();
        this.VARIANT.withValidInput(this.variantMap.keySet());
        this.registerSingle((SingleProperty<?>)this.VARIANT);
    }

    @Override
    @Nullable
    protected Parrot tryCastEntity(@Nullable Entity targetEntity) {
        Parrot parrot;
        return targetEntity instanceof Parrot ? (parrot = (Parrot)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Parrot targetEntity) {
        propertyHandler.set(this.VARIANT, targetEntity.getVariant());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.getRandomValues()));
    }
}

