/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Wolf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.DisguiseUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class WolfProperties
extends BaseLivingEntityProperties<Wolf> {
    private final Map<String, Wolf.Variant> variantMap = new ConcurrentHashMap<String, Wolf.Variant>();
    public final SingleProperty<Wolf.Variant> VARIANT = this.createProperty("wolf/variant", Wolf.Variant.PALE, this::readWolfVariant, OutputHandles::writeKeyed).withRandom(RegistryAccess.registryAccess().getRegistry(RegistryKey.WOLF_VARIANT).stream().toList());
    public final SingleProperty<UUID> OWNER = this.createProperty("wolf/owner", Uuids.NIL_UUID, InputHandles::readUUID, OutputHandles::writeUUID);
    public final SingleProperty<DyeColor> COLLAR_COLOR = this.createProperty("wolf/collar_color", DyeColor.RED, InputHandles::readDyeColor, OutputHandles::writeEnum);

    private void initMap() {
        for (Wolf.Variant variant : RegistryAccess.registryAccess().getRegistry(RegistryKey.WOLF_VARIANT)) {
            this.variantMap.put(variant.key().asString(), variant);
        }
    }

    public Optional<Wolf.Variant> readWolfVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readRegistry(RegistryKey.WOLF_VARIANT, propertyName, string);
    }

    public WolfProperties() {
        this.initMap();
        this.VARIANT.withValidInput(this.variantMap.keySet());
        this.COLLAR_COLOR.withValidInput(Arrays.stream(DyeColor.values()).map(c -> c.name().toLowerCase()).toList());
        this.registerSingle(this.VARIANT, this.OWNER, this.COLLAR_COLOR);
    }

    @Override
    @Nullable
    protected Wolf tryCastEntity(@Nullable Entity targetEntity) {
        Wolf wolf;
        return targetEntity instanceof Wolf ? (wolf = (Wolf)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Wolf targetEntity) {
        propertyHandler.set(this.VARIANT, targetEntity.getVariant());
        propertyHandler.set(this.COLLAR_COLOR, targetEntity.getCollarColor());
        if (targetEntity.getOwnerUniqueId() != null) {
            propertyHandler.set(this.OWNER, targetEntity.getOwnerUniqueId());
        }
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.getRandomValues()));
    }
}

