/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.mobs.goal.impl;

import java.util.Optional;
import net.minecraft.world.entity.ai.goal.Goal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Rabbit;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.misc.mobs.goal.IGoalProvider;
import xyz.nifeather.morph.misc.mobs.goal.impl.MorphBasicAvoidPlayerGoal;

public class MorphRabbitAvoidPlayerGoal
extends MorphBasicAvoidPlayerGoal<Rabbit> {
    public static final RabbitGoalProvider GOAL_PROVIDER = new RabbitGoalProvider();

    public MorphRabbitAvoidPlayerGoal(Rabbit bindingMob, RevealingHandler revealingHandler, MorphManager morphManager, double detectDistance, double walkSpeed, double sprintSpeed) {
        super(bindingMob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
    }

    @Override
    public boolean canUse() {
        return ((Rabbit)this.mob).getRabbitType() != Rabbit.Type.THE_KILLER_BUNNY && super.canUse();
    }

    @Override
    protected boolean mobPanicFromPlayerByDefault() {
        return true;
    }

    public static class RabbitGoalProvider
    implements IGoalProvider<Rabbit> {
        @Override
        public Optional<Rabbit> tryCast(Entity entity) {
            Rabbit Rabbit2;
            return Optional.ofNullable(entity instanceof Rabbit ? (Rabbit2 = (Rabbit)entity) : null);
        }

        @Override
        public Goal createGoal(Rabbit mob, @NotNull MorphManager morphManager, @NotNull RevealingHandler revealingHandler, double detectDistance, double walkSpeed, double sprintSpeed) {
            return new MorphRabbitAvoidPlayerGoal(mob, revealingHandler, morphManager, detectDistance, walkSpeed, sprintSpeed);
        }
    }
}

