/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.waypoint.connection;

import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTrackedWaypointPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;

public class MorphAzimuthWaypointConnection
implements WaypointTransmitter.Connection {
    private final DisguiseState bindingState;
    private final Waypoint.Icon icon;
    private final ServerPlayer receiver;
    private final Player receiverBukkit;
    private float lastAngle;

    public MorphAzimuthWaypointConnection(DisguiseState state, Waypoint.Icon icon, ServerPlayer receiver) {
        this.bindingState = state;
        this.icon = icon;
        this.receiver = receiver;
        this.receiverBukkit = receiver.getBukkitEntity();
    }

    public void connect() {
        UUID uuid = this.bindingState.getDisguiseWrapper().getVirtualEntityUUID();
        this.receiver.connection.send((Packet)ClientboundTrackedWaypointPacket.addWaypointAzimuth((UUID)uuid, (Waypoint.Icon)this.icon, (float)this.lastAngle));
    }

    public void disconnect() {
        UUID uuid = this.bindingState.getDisguiseWrapper().getVirtualEntityUUID();
        this.receiver.connection.send((Packet)ClientboundTrackedWaypointPacket.removeWaypoint((UUID)uuid));
    }

    public void update() {
        Player player = this.bindingState.getPlayer();
        if (!player.getLocation().getWorld().equals((Object)this.receiverBukkit.getLocation().getWorld())) {
            return;
        }
        Location vec = this.receiverBukkit.getLocation().subtract(player.getLocation());
        float angle = (float)Math.atan2((vec = new Location(vec.getWorld(), -vec.z(), vec.y(), vec.x())).z(), vec.x());
        if (Mth.abs((float)(angle - this.lastAngle)) > (float)Math.PI / 360) {
            UUID uuid = this.bindingState.getDisguiseWrapper().getVirtualEntityUUID();
            this.receiver.connection.send((Packet)ClientboundTrackedWaypointPacket.updateWaypointAzimuth((UUID)uuid, (Waypoint.Icon)this.icon, (float)angle));
            this.lastAngle = angle;
        }
    }

    public boolean isBroken() {
        ServerPlayer source = NmsRecord.ofPlayer(this.bindingState.getPlayer());
        return !WaypointTransmitter.isReallyFar((LivingEntity)source, (ServerPlayer)this.receiver);
    }
}

