/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.platform.impl.paper.entity;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import xyz.nifeather.morph.platform.CurrentPlatform;
import xyz.nifeather.morph.platform.entity.IPlatformEntity;
import xyz.nifeather.morph.platform.impl.paper.PaperPlatform;
import xyz.nifeather.morph.platform.world.IPlatformLocation;
import xyz.nifeather.morph.platform.world.IPlatformWorld;

public class PaperEntity
implements IPlatformEntity {
    private final LivingEntity handle;
    private final PaperPlatform platform;

    public PaperEntity(LivingEntity handle) {
        this.handle = handle;
        this.platform = CurrentPlatform.instance();
    }

    @Override
    public int entityId() {
        return this.handle.getEntityId();
    }

    @Override
    public UUID uuid() {
        return this.handle.getUniqueId();
    }

    @Override
    public IPlatformLocation location() {
        return this.platform.worldLookup().getPlatformLocation(this.handle.getLocation());
    }

    @Override
    public IPlatformWorld world() {
        return this.platform.worldLookup().getPlatformWorld(this.handle.getWorld());
    }

    @Override
    public CompletableFuture<Boolean> teleportAsync(IPlatformLocation targetLocation) {
        Location nativeLocation = this.platform.worldLookup().getNativeLocation(targetLocation);
        return this.getHandle().teleportAsync(nativeLocation);
    }

    @Override
    public void damage(double amount) {
        this.handle.damage(amount);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PaperEntity)) {
            return false;
        }
        PaperEntity other = (PaperEntity)obj;
        return this.handle.equals((Object)other.handle);
    }

    public LivingEntity getHandle() {
        return this.handle;
    }
}

