/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Configuration;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.BindableList;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigNode;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigOption;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.IConfigManager;
import xyz.nifeather.morph.shaded.pluginbase.Utilities.ConfigSerializeUtils;
import xyz.nifeather.morph.shaded.pluginbase.XiaMoJavaPlugin;

public class PluginConfigManager
implements IConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfigManager.class);
    protected FileConfiguration backendConfig;
    protected final XiaMoJavaPlugin plugin;
    private Map<String, BindableList<?>> bindableLists;
    private final Map<String, Bindable<?>> stringConfigNodeMap = new Object2ObjectOpenHashMap();
    private final Map<ConfigNode, Object> emptyMap = new HashMap<ConfigNode, Object>();
    private final ArrayList<Consumer<?>> onRefresh = new ArrayList();

    public PluginConfigManager(XiaMoJavaPlugin plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.reload();
    }

    public <T> T get(ConfigOption<T> option) {
        Class<Object> clazz = option.getDefault().getClass();
        if (option.getDefault() instanceof List) {
            clazz = List.class;
        }
        return (T)this.get(clazz, option.node());
    }

    @Override
    @Nullable
    public <T> T get(Class<T> type, ConfigNode node) {
        Object value;
        if (type == Object.class) {
            logger.warn("[PluginBase] Trying to get an object instance from a node, this is bad!");
        }
        if ((value = this.backendConfig.get(node.toString(), null)) == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            Number numVal;
            Number num;
            Class<Number> numClass = Number.class;
            if (numClass.isAssignableFrom(type) && value instanceof Number && (num = ConfigSerializeUtils.convertNumber(type, numVal = (Number)value, true)) != null) {
                return (T)num;
            }
            logger.warn("Unable to convert value under node '%s' from '%s' to '%s'".formatted(node, value.getClass().getSimpleName(), type.getSimpleName()));
            Thread.dumpStack();
            return null;
        }
        return (T)value;
    }

    @Override
    public <T> T getOrDefault(Class<T> type, ConfigNode node, @Nullable T defaultValue) {
        T val = this.get(type, node);
        if (val == null) {
            this.set(node, defaultValue);
            return defaultValue;
        }
        return val;
    }

    public <T> T getOrDefault(ConfigOption<T> option) {
        T val = this.get(option);
        if (val == null) {
            T defaultVal = option.getDefault();
            this.set(option, defaultVal);
            return defaultVal;
        }
        return val;
    }

    public <T> T getOrDefault(ConfigOption<T> option, @Nullable T defaultValue) {
        T val = this.get(option);
        if (val == null) {
            this.set(option, defaultValue);
            return defaultValue;
        }
        return val;
    }

    @Override
    @NotNull
    public Map<ConfigNode, Object> getAllNotDefault() {
        return this.emptyMap;
    }

    @Override
    public <T> Bindable<T> getBindable(Class<T> type, ConfigNode path, T defaultValue) {
        Bindable bindable = this.stringConfigNodeMap.getOrDefault(path.toString(), null);
        if (bindable != null && type.isInstance(bindable.get())) {
            return bindable;
        }
        Bindable<Object> newBindable = new Bindable<Object>(this.getOrDefault(type, path, defaultValue));
        this.stringConfigNodeMap.put(path.toString(), newBindable);
        newBindable.onValueChanged((o, n) -> this.set(path, n, true));
        return newBindable;
    }

    @Override
    public <T> Bindable<T> getBindable(Class<T> type, ConfigNode path) {
        return this.getBindable(type, path, null);
    }

    public <T> Bindable<T> getBindable(ConfigOption<T> option) {
        return this.getBindable(option, option.getDefault());
    }

    public <T> Bindable<T> getBindable(ConfigOption<T> path, T defaultValue) {
        return this.getBindable(path.getDefault().getClass(), path.node(), defaultValue);
    }

    private void ensureBindableListNotNull() {
        if (this.bindableLists == null) {
            this.bindableLists = new Object2ObjectOpenHashMap();
        }
    }

    public <T> BindableList<T> getBindableList(Class<T> elementClass, ConfigOption<List<T>> option) {
        this.ensureBindableListNotNull();
        BindableList val = this.bindableLists.getOrDefault(option.node().toString(), null);
        if (val != null) {
            return val;
        }
        List originalList = this.backendConfig.getList(option.node().toString(), new ArrayList());
        originalList.removeIf(listVal -> !elementClass.isInstance(listVal));
        BindableList list = new BindableList();
        list.addAll(originalList);
        list.onListChanged((diffList, reason) -> {
            this.backendConfig.set(option.node().toString(), new ArrayList(list));
            this.save();
        }, true);
        this.bindableLists.put(option.node().toString(), list);
        return list;
    }

    public <T> void bind(Bindable<T> bindable, ConfigNode node, Class<T> type) {
        Bindable<T> bb = this.getBindable(type, node);
        bindable.bindTo(bb);
    }

    public <T> void bind(Bindable<T> bindable, ConfigOption<T> option) {
        Bindable<T> bb = this.getBindable(option);
        if (!bindable.getClass().isInstance(bb)) {
            throw new IllegalArgumentException("\u5c1d\u8bd5\u5c06\u4e00\u4e2aBindable\u7ed1\u5b9a\u5728\u4e0d\u517c\u5bb9\u7684\u914d\u7f6e(" + String.valueOf(option) + ")\u4e0a");
        }
        bindable.bindTo(bb);
    }

    public <T> void bind(BindableList<T> bindable, ConfigOption<List<T>> option, Class<T> elementClass) {
        BindableList<T> bb = this.getBindableList(elementClass, option);
        if (!bindable.getClass().isInstance(bb)) {
            throw new IllegalArgumentException("\u5c1d\u8bd5\u5c06\u4e00\u4e2aBindable\u7ed1\u5b9a\u5728\u4e0d\u517c\u5bb9\u7684\u914d\u7f6e(" + String.valueOf(option) + ")\u4e0a");
        }
        bindable.bindTo(bb);
    }

    private <T> boolean set(ConfigNode node, T value, boolean isInternal) {
        this.backendConfig.set(node.toString(), value);
        this.save();
        if (!isInternal) {
            if (value != null) {
                Bindable<?> bindable = this.getBindable(value.getClass(), node);
                bindable.set(value);
            } else {
                Bindable bindable = this.stringConfigNodeMap.getOrDefault(node.toString(), null);
                if (bindable != null) {
                    bindable.set(null);
                } else {
                    logger.warn("No bindable found for node '%s', is it still in the config file?".formatted(node));
                }
            }
        }
        return true;
    }

    @Override
    public <T> boolean set(ConfigNode node, T value) {
        return this.set(node, value, false);
    }

    public <T> void set(ConfigOption<T> option, T val) {
        this.set(option.node(), val);
    }

    @Override
    public boolean restoreDefaults() {
        this.plugin.saveResource("config.yml", true);
        this.plugin.saveConfig();
        this.reload();
        return true;
    }

    @Override
    public boolean save() {
        this.plugin.saveConfig();
        return true;
    }

    @Override
    public void reload() {
        this.plugin.reloadConfig();
        this.backendConfig = this.plugin.getConfig();
        this.ensureBindableListNotNull();
        this.stringConfigNodeMap.forEach((str, bindable) -> {
            try {
                Object valRaw = this.backendConfig.get(str);
                if (valRaw instanceof Number) {
                    Number numVal = (Number)valRaw;
                    ConfigSerializeUtils.tryCastNumberBindable(bindable, numVal);
                } else {
                    bindable.setInternal(bindable.tryCast(valRaw));
                }
            }
            catch (Throwable t) {
                logger.warn("[PluginBase] Unable to set value for Bindable bind to config node %s: %s".formatted(str, t.getMessage()));
                t.printStackTrace();
            }
        });
        this.bindableLists.forEach((node, list) -> {
            List configList = this.backendConfig.getList(node);
            configList = configList == null ? new ObjectArrayList() : new ObjectArrayList((Collection)configList);
            list.clear();
            list.addAllInternal(configList);
        });
        for (Consumer<?> c : this.onRefresh) {
            try {
                c.accept(null);
            }
            catch (Throwable t) {
                logger.warn("Exception thrown while calling one of the onRefresh hooks: " + t.getMessage());
                t.printStackTrace();
            }
        }
        this.plugin.saveConfig();
    }

    @Override
    @Deprecated
    public boolean onConfigRefresh(Consumer<?> c) {
        if (this.onRefresh.contains(c)) {
            return false;
        }
        this.onRefresh.add(c);
        return true;
    }

    @Override
    @Deprecated
    public boolean onConfigRefresh(Consumer<?> c, boolean runOnce) {
        boolean ocr = this.onConfigRefresh(c);
        if (!ocr) {
            return false;
        }
        c.accept(null);
        return true;
    }
}

