/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills;

import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.api.events.lifecycle.SkillsFinishedInitializeEvent;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.skills.CooldownManager;
import xyz.nifeather.morph.skills.ISkill;
import xyz.nifeather.morph.skills.impl.ApplyEffectMorphSkill;
import xyz.nifeather.morph.skills.impl.EvokerMorphSkill;
import xyz.nifeather.morph.skills.impl.ExplodeMorphSkill;
import xyz.nifeather.morph.skills.impl.GuardianSkill;
import xyz.nifeather.morph.skills.impl.InventoryMorphSkill;
import xyz.nifeather.morph.skills.impl.LaunchProjectileMorphSkill;
import xyz.nifeather.morph.skills.impl.NoneMorphSkill;
import xyz.nifeather.morph.skills.impl.SonicBoomMorphSkill;
import xyz.nifeather.morph.skills.impl.SplashPotionSkill;
import xyz.nifeather.morph.skills.impl.TeleportMorphSkill;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;
import xyz.nifeather.morph.storage.skill.SkillAbilityConfigContainer;
import xyz.nifeather.morph.storage.skill.SkillsConfigurationStoreNew;

public class SkillManager
extends MorphPluginObject {
    private final Map<String, ISkill<?>> skills = new ConcurrentHashMap();
    private final CooldownManager cooldownManager = new CooldownManager();
    @Resolved
    private SkillsConfigurationStoreNew store;

    public List<ISkill<?>> getRegistedSkills() {
        return this.skills.values().stream().toList();
    }

    public CooldownManager cooldownManager() {
        return this.cooldownManager;
    }

    @Initializer
    private void load() {
        this.registerSkills((List<ISkill<?>>)ObjectList.of((Object[])new ISkill[]{new ApplyEffectMorphSkill(), new ExplodeMorphSkill(), new InventoryMorphSkill(), new LaunchProjectileMorphSkill(), new EvokerMorphSkill(), new TeleportMorphSkill(), new SonicBoomMorphSkill(), new SplashPotionSkill(), new GuardianSkill(), NoneMorphSkill.instance}));
        Bukkit.getPluginManager().callEvent((Event)new SkillsFinishedInitializeEvent(this));
    }

    public boolean registerSkills(List<ISkill<?>> skills) {
        AtomicBoolean success = new AtomicBoolean(true);
        skills.forEach(s -> {
            if (!this.registerSkill((ISkill<?>)s)) {
                success.set(false);
            }
        });
        return success.get();
    }

    public boolean registerSkill(ISkill<?> skill) {
        if (this.skills.containsKey(skill.getIdentifier().asString())) {
            this.logger.error("Can't register skill: Another skill instance has already registered as " + skill.getIdentifier().asString() + " !");
            return false;
        }
        if (skill.getIdentifier().equals((Object)SkillNames.UNKNOWN)) {
            this.logger.error("Can't register skill: Illegal skill identifier: " + String.valueOf(SkillNames.UNKNOWN));
            return false;
        }
        this.skills.put(skill.getIdentifier().asString(), skill);
        return true;
    }

    @NotNull
    public ISkill<?> lookupDisguiseSkill(String disguiseIdentifier) {
        SkillAbilityConfigContainer configuration = (SkillAbilityConfigContainer)this.store.get(disguiseIdentifier);
        if (configuration == null) {
            return NoneMorphSkill.instance;
        }
        return this.getSkill(configuration.getSkillIdentifier().asString());
    }

    public SkillAbilityConfigContainer getConfiguration(String lookupId) {
        return (SkillAbilityConfigContainer)this.store.get(lookupId);
    }

    public boolean hasSkillAbilityConfiguration(String lookupId) {
        return this.getConfiguration(lookupId) != null;
    }

    public <O extends ISkillAbilityOption> O lookupOptionFor(ISkill<O> skill, String skillLookup) throws ParseErrorException, NullPointerException {
        SkillAbilityConfigContainer configContainer = (SkillAbilityConfigContainer)this.store.get(skillLookup);
        Map<String, Object> optionMap = Objects.requireNonNull(configContainer, "No configuration for id " + skillLookup).getSkillOptions(skill);
        return skill.optionHandler().acceptNullableOptions() ? skill.optionHandler().readOptionNullable(optionMap) : skill.optionHandler().readOption(optionMap);
    }

    @NotNull
    public ISkill<?> getSkill(String skillIdentifier) {
        return this.skills.getOrDefault(skillIdentifier, NoneMorphSkill.instance);
    }

    public long getAvailableAfter(UUID uuid, @Nullable String disguiseIdentifier) {
        return this.cooldownManager.pull(uuid, disguiseIdentifier);
    }

    public boolean hasSkill(String disguiseIdentifier) {
        SkillAbilityConfigContainer container = (SkillAbilityConfigContainer)this.store.get(disguiseIdentifier);
        if (container == null) {
            return false;
        }
        return !SkillNames.UNKNOWN.equals((Object)container.getSkillIdentifier()) && !SkillNames.NONE.equals((Object)container.getSkillIdentifier());
    }

    public boolean hasSpeficSkill(String id, NamespacedKey skillKey) {
        SkillAbilityConfigContainer container = (SkillAbilityConfigContainer)this.store.get(id);
        if (container == null) {
            return false;
        }
        if (SkillNames.UNKNOWN.equals((Object)container.getSkillIdentifier())) {
            return false;
        }
        return container.getSkillIdentifier().equals((Object)skillKey);
    }

    public void trim() {
        this.cooldownManager.trim();
    }
}

