/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.storage.playerdata;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.Expose;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class PlayerMeta {
    @Expose(serialize=false)
    public UUID uniqueId;
    @Expose
    @Nullable
    public String playerName;
    @Expose(serialize=false)
    private List<DisguiseMeta> unlockedDisguises = Collections.synchronizedList(new ObjectArrayList());
    @Expose
    private List<String> unlockedDisguiseIdentifiers = Collections.synchronizedList(new ObjectArrayList());
    @Expose
    public boolean showDisguiseToSelf = false;
    @Expose
    public boolean shownDisplayToSelfHint = false;
    @Expose
    @Deprecated(forRemoval=true)
    public boolean shownServerSkillHint;
    @Expose
    public boolean shownClientSkillHint;
    @Expose
    public boolean shownMorphHint;
    @Expose
    public boolean shownMorphClientHint;

    public @Unmodifiable List<DisguiseMeta> getUnlockedDisguises() {
        return ImmutableList.copyOf(this.unlockedDisguises);
    }

    public void setUnlockedDisguises(ObjectArrayList<DisguiseMeta> newList) {
        this.unlockedDisguises = newList;
    }

    public void addDisguise(DisguiseMeta info) {
        this.unlockedDisguiseIdentifiers.add(DisguiseUtils.asString(info));
        this.unlockedDisguises.add(info);
    }

    public void addUnmanagedDisguise(String identifier) {
        this.unlockedDisguiseIdentifiers.add(identifier);
    }

    public void removeDisguise(DisguiseMeta info) {
        this.unlockedDisguiseIdentifiers.remove(DisguiseUtils.asString(info));
        this.unlockedDisguises.remove(info);
    }

    @ApiStatus.Internal
    public void addUnlockedDisguiseIdentifier(List<String> list) {
        this.unlockedDisguiseIdentifiers.addAll(list);
    }

    public @Unmodifiable List<String> getUnlockedDisguiseIdentifiers() {
        return ImmutableList.copyOf(this.unlockedDisguiseIdentifiers);
    }

    public void setUnlockedDisguiseIdentifiers(List<String> newList) {
        this.unlockedDisguiseIdentifiers = newList;
    }

    public String toString() {
        return "PlayerMeta{ UUID=%s, Name=%s }".formatted(this.uniqueId, this.playerName);
    }
}

