/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.WrapperEvent;
import xyz.nifeather.morph.backends.WrapperProperties;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;

public abstract class DisguiseWrapper<TInstance> {
    private static final Logger log = LoggerFactory.getLogger(DisguiseWrapper.class);
    protected TInstance instance;
    private final DisguiseBackend<TInstance, ? extends DisguiseWrapper<TInstance>> backend;
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    public DisguiseWrapper(@NotNull TInstance instance, DisguiseBackend<TInstance, ? extends DisguiseWrapper<TInstance>> backend) {
        this.instance = instance;
        this.backend = backend;
    }

    public TInstance getInstance() {
        return this.instance;
    }

    public DisguiseBackend<TInstance, ? extends DisguiseWrapper<TInstance>> getBackend() {
        return this.backend;
    }

    public abstract void setServerSelfView(boolean var1);

    public abstract EntityType getEntityType();

    public abstract TInstance copyInstance();

    public void onPlayerOffline() {
    }

    public abstract DisguiseWrapper<TInstance> clone();

    public String getDisguiseName() {
        return this.readProperty(WrapperProperties.DISGUISE_NAME);
    }

    public void setDisguiseName(String name) {
        this.writeProperty(WrapperProperties.DISGUISE_NAME, name);
    }

    public abstract boolean isBaby();

    public abstract void postBuildDisguise(DisguiseState var1, @Nullable Entity var2);

    public abstract void update();

    @Deprecated
    public abstract CompoundTag getCompound();

    @NotNull
    public abstract UUID getVirtualEntityUUID();

    public boolean disposed() {
        return this.disposed.get();
    }

    public void dispose() {
        this.disposed.set(true);
    }

    public void setSaddled(boolean saddled) {
        this.writeProperty(WrapperProperties.SADDLED, saddled);
    }

    public boolean isSaddled() {
        return this.readProperty(WrapperProperties.SADDLED);
    }

    public void setAggressive(boolean aggressive) {
    }

    public void playAttackAnimation() {
    }

    public abstract <X> void writeProperty(SingleProperty<X> var1, X var2);

    @NotNull
    public abstract <X> X readProperty(SingleProperty<X> var1);

    public abstract <X> X readPropertyOr(SingleProperty<X> var1, X var2);

    public abstract <X> X readPropertyOrThrow(SingleProperty<X> var1);

    public abstract Map<SingleProperty<?>, Object> getProperties();

    public void playAnimation(String animationId) {
    }

    public void onPlayerJoin(Player newInstance) {
    }

    public abstract <T> void subscribeEvent(Object var1, WrapperEvent<T> var2, Consumer<T> var3);

    public abstract void unSubscribeEvent(Object var1, WrapperEvent<?> var2);
}

