/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.entity.cow.CowVariant;
import com.github.retrooper.packetevents.protocol.entity.cow.CowVariants;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.AgeableMobWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.CowPropertyCollection;

public class CowWatcher
extends AgeableMobWatcher {
    private final CowPropertyCollection cowProperties = DisguiseProperties.INSTANCE.getCollectionOrThrow(CowPropertyCollection.class);

    public CowWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.COW);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.COW);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        if (Objects.equals(property, this.cowProperties.VARIANT)) {
            Cow.Variant bukkitVariant = (Cow.Variant)value;
            CowVariant packetVariant = Objects.requireNonNull((CowVariant)CowVariants.getRegistry().getByName(bukkitVariant.key().asString()), "No packet version for bukkit variant %s!".formatted(bukkitVariant));
            this.writePersistent(ValueIndex.COW.COW_VARIANT, packetVariant);
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        CowVariant variant = this.readOr(ValueIndex.COW.COW_VARIANT, null);
        if (variant != null) {
            nbt.putString("variant", variant.getName().toString());
        }
        super.writeToCompound(nbt);
    }
}

