/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.entity.frog.FrogVariant;
import com.github.retrooper.packetevents.protocol.entity.frog.FrogVariants;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.FrogPropertyCollection;

public class FrogWatcher
extends LivingEntityWatcher {
    public FrogWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.FROG);
    }

    private FrogVariant getFrogVariant(NamespacedKey key) {
        return Objects.requireNonNull((FrogVariant)FrogVariants.getRegistry().getByName(key.asString()), "No packet version frog variant: %s".formatted(key.asString()));
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.FROG);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        FrogPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(FrogPropertyCollection.class);
        if (property.equals(properties.VARIANT)) {
            Frog.Variant variant = (Frog.Variant)value;
            this.writePersistent(ValueIndex.FROG.FROG_VARIANT, this.getFrogVariant(variant.getKey()));
        }
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId = newVal.toString();
            Player player = this.getBindingPlayer();
            World world = player.getWorld();
            switch (animId) {
                case "eat": {
                    this.writePersistent(ValueIndex.FROG.POSE, EntityPose.USING_TONGUE);
                    world.playSound(player.getLocation(), Sound.ENTITY_FROG_EAT, 1.0f, 1.0f);
                    break;
                }
                case "reset": {
                    this.remove(ValueIndex.FROG.POSE);
                }
            }
        }
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        String variant = this.read(ValueIndex.FROG.FROG_VARIANT).getName().toString();
        nbt.putString("variant", variant);
    }
}

