/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.GoatPropertyCollection;

public class GoatWatcher
extends LivingEntityWatcher {
    public GoatWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.GOAT);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.GOAT);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        GoatPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(GoatPropertyCollection.class);
        if (property.equals(properties.HAS_LEFT_HORN)) {
            this.writePersistent(ValueIndex.GOAT.HAS_LEFT_HORN, (Boolean)value);
        }
        if (property.equals(properties.HAS_RIGHT_HORN)) {
            this.writePersistent(ValueIndex.GOAT.HAS_RIGHT_HORN, (Boolean)value);
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        nbt.putBoolean("HasLeftHorn", this.read(ValueIndex.GOAT.HAS_LEFT_HORN).booleanValue());
        nbt.putBoolean("HasRightHorn", this.read(ValueIndex.GOAT.HAS_RIGHT_HORN).booleanValue());
        nbt.putBoolean("IsScreamingGoat", this.read(ValueIndex.GOAT.IS_SCREAMING).booleanValue());
    }
}

