/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.horses;

import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.horses.AbstractHorseWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.HorsePropertyCollection;

public class HorseWatcher
extends AbstractHorseWatcher {
    private Horse.Color horseColor;
    private Horse.Style horseStyle;

    public HorseWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.HORSE);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.HORSE);
    }

    public Horse.Color getColor() {
        Integer value = this.read(ValueIndex.HORSE.HORSE_VARIANT);
        int type = value & 0xFF;
        return Horse.Color.values()[type];
    }

    public Horse.Style getStyle() {
        Integer value = this.read(ValueIndex.HORSE.HORSE_VARIANT);
        int type = value >> 8;
        return Horse.Style.values()[type];
    }

    private int computeHorseVariant() {
        Horse.Color color = this.horseColor == null ? Horse.Color.WHITE : this.horseColor;
        Horse.Style style = this.horseStyle == null ? Horse.Style.NONE : this.horseStyle;
        return color.ordinal() | style.ordinal() << 8;
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        HorsePropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(HorsePropertyCollection.class);
        if (property.equals(properties.COLOR)) {
            this.horseColor = (Horse.Color)value;
            this.writePersistent(ValueIndex.HORSE.HORSE_VARIANT, this.computeHorseVariant());
        }
        if (property.equals(properties.STYLE)) {
            this.horseStyle = (Horse.Style)value;
            this.writePersistent(ValueIndex.HORSE.HORSE_VARIANT, this.computeHorseVariant());
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        nbt.putInt("Variant", this.read(ValueIndex.HORSE.HORSE_VARIANT).intValue());
    }
}

