/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.SkinCacheStrings;
import xyz.nifeather.morph.misc.CapeURL;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.MorphParameters;
import xyz.nifeather.morph.misc.skins.PlayerSkinProvider;
import xyz.nifeather.morph.misc.skins.SingleSkin;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class SkinCacheSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    private final PlayerSkinProvider skinProvider = PlayerSkinProvider.getInstance();
    @Resolved(shouldSolveImmediately=true)
    private MorphManager morphManager;
    private final Bindable<Boolean> debug = new Bindable<Boolean>(false);

    @Override
    @NotNull
    public String name() {
        return "skin_cache";
    }

    @Override
    @Nullable
    public String permission() {
        return "feathermorph.skin_cache";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return new FormattableMessage(this.plugin, "skin_cache");
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> this.executeList((CommandContext<CommandSourceStack>)ctx, null))).then(Commands.argument((String)"amount", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> builder.suggest("all").buildFuture()).executes(ctx -> this.executeList((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"amount")))))).then(Commands.literal((String)"drop").then(Commands.argument((String)"skin", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            List<SingleSkin> allSkin = this.skinProvider.getAllSkins();
            return CompletableFuture.supplyAsync(() -> {
                String input = builder.getRemainingLowerCase();
                allSkin.forEach(singleSkin -> {
                    String skinName = singleSkin.name;
                    if (skinName.toLowerCase().contains(input)) {
                        builder.suggest(skinName);
                    }
                });
                return builder.build();
            });
        }).executes(this::executeDrop)))).then(Commands.literal((String)"cache").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::executeCache)))).then(Commands.literal((String)"info").then(Commands.argument((String)"skin", (ArgumentType)StringArgumentType.string()).suggests(this::filterSkinName).executes(this::executeInfo)))).then(Commands.literal((String)"disguise").then(Commands.argument((String)"skin", (ArgumentType)StringArgumentType.string()).suggests(this::filterSkinName).executes(this::executeDisguise)))).then(Commands.literal((String)"copy").then(Commands.argument((String)"source", (ArgumentType)StringArgumentType.string()).suggests(this::filterSkinName).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.string()).executes(this::executeCopy))))).then(Commands.literal((String)"rename").then(Commands.argument((String)"from", (ArgumentType)StringArgumentType.string()).suggests(this::filterSkinName).then(Commands.argument((String)"to", (ArgumentType)StringArgumentType.string()).executes(this::executeRename)))));
    }

    private CompletableFuture<Suggestions> filterSkinName(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
        String targetName = suggestionsBuilder.getRemainingLowerCase();
        List<SingleSkin> allSkin = this.skinProvider.getAllSkins();
        return CompletableFuture.supplyAsync(() -> {
            allSkin.forEach(singleSkin -> {
                String skinName = singleSkin.name;
                if (skinName.toLowerCase().contains(targetName)) {
                    suggestionsBuilder.suggest(skinName);
                }
            });
            return suggestionsBuilder.build();
        });
    }

    private int executeDrop(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String targetName = StringArgumentType.getString(context, (String)"skin");
        if (targetName.equals("*")) {
            int skinCount = this.skinProvider.getAllSkins().size();
            this.skinProvider.dropAll();
            MessageUtils.send(sender, SkinCacheStrings.droppedAllSkins().resolve("count", "" + skinCount));
        } else {
            this.skinProvider.dropSkin(targetName);
            MessageUtils.send(sender, SkinCacheStrings.droppedSkin().resolve("name", targetName));
        }
        return 1;
    }

    private int executeList(CommandContext<CommandSourceStack> context, @Nullable String exInput) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        long currentTime = System.currentTimeMillis();
        List<SingleSkin> skins = this.skinProvider.getAllSkins();
        TextComponent str = Component.empty();
        MessageUtils.send(sender, SkinCacheStrings.listHeader().resolve("count", "" + skins.size()));
        int limit = 20;
        if (exInput != null) {
            try {
                limit = exInput.equals("all") ? Integer.MAX_VALUE : Integer.parseInt(exInput);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        limit = Math.min(1, limit);
        int current = 0;
        FormattableMessage overallLine = SkinCacheStrings.skinInfoOverallLine();
        Component expiredString = SkinCacheStrings.skinExpired().createComponent(MessageUtils.getLocale(sender));
        overallLine.resolve("x_more", (Component)Component.empty());
        Iterator<SingleSkin> it = skins.iterator();
        while (it.hasNext()) {
            ++current;
            SingleSkin next = it.next();
            str = (TextComponent)str.append((Component)Component.text((String)next.name));
            if (currentTime > next.expiresAt) {
                str = (TextComponent)str.append(expiredString);
            }
            if (it.hasNext() && current != limit) {
                str = (TextComponent)str.append((Component)Component.text((String)", "));
            }
            if (current != limit) continue;
            int remaining = skins.size() - current;
            overallLine.resolve("x_more", SkinCacheStrings.andXMore().resolve("count", "" + remaining));
            break;
        }
        overallLine.resolve("info_line", (Component)str);
        MessageUtils.send(sender, overallLine);
        return 1;
    }

    private int executeCache(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String targetName = StringArgumentType.getString(context, (String)"name");
        MessageUtils.send(sender, SkinCacheStrings.fetchingSkin().resolve("name", targetName));
        this.skinProvider.invalidate(targetName);
        this.skinProvider.fetchSkin(targetName).thenAccept(optional -> optional.ifPresentOrElse(profile -> MessageUtils.send(sender, SkinCacheStrings.fetchSkinSuccess().resolve("name", targetName)), () -> MessageUtils.send(sender, SkinCacheStrings.targetSkinNotFound())));
        return 1;
    }

    private int executeInfo(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String targetName = StringArgumentType.getString(context, (String)"skin");
        GameProfile skinMatch = this.skinProvider.getCachedProfile(targetName);
        if (skinMatch == null) {
            MessageUtils.send(sender, SkinCacheStrings.targetSkinNotFound());
            return 1;
        }
        String texDesc = "<Nil>";
        String capeDesc = "<Nil>";
        Property tex = skinMatch.properties().get((Object)"textures").stream().findFirst().orElse(null);
        if (tex != null) {
            URL capeURL;
            PlayerProfile playerProfile = CraftPlayerProfile.asBukkitCopy((GameProfile)skinMatch);
            URL skinURL = playerProfile.getTextures().getSkin();
            if (skinURL != null) {
                texDesc = skinURL.toString();
            }
            if ((capeURL = playerProfile.getTextures().getCape()) != null) {
                capeDesc = capeURL.toString();
            }
        }
        MessageUtils.send(sender, SkinCacheStrings.infoLine().resolve("name", skinMatch.name()));
        MessageUtils.send(sender, SkinCacheStrings.infoSkinLine().resolve("url", ((TextComponent)Component.text((String)texDesc).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.OPEN_URL, (String)texDesc))).decorate(TextDecoration.UNDERLINED)));
        MessageUtils.send(sender, SkinCacheStrings.infoCapeLine().resolve("cape", CapeURL.findMatching(capeDesc)));
        if (this.debug.get().booleanValue()) {
            sender.sendMessage("Cape " + capeDesc);
        }
        return 1;
    }

    private int executeDisguise(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(sender instanceof Player)) {
            MessageUtils.send(sender, CommandStrings.unknownOperation().resolve("operation", "disguise_from_skin_cache_in_console"));
            return 1;
        }
        Player player = (Player)sender;
        String targetName = StringArgumentType.getString(context, (String)"skin");
        GameProfile skinMatch = this.skinProvider.getCachedProfile(targetName);
        if (skinMatch == null) {
            MessageUtils.send(sender, SkinCacheStrings.targetSkinNotFound());
            return 1;
        }
        MorphParameters parameters = MorphParameters.create(player, DisguiseTypes.PLAYER.toId(skinMatch.name())).setSource(sender).setBypassAvailableCheck(true);
        this.morphManager.morph(parameters);
        return 1;
    }

    private int executeCopy(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String sourceName = StringArgumentType.getString(context, (String)"source");
        String targetName = StringArgumentType.getString(context, (String)"target");
        this.copyOrMoveSkin(sender, sourceName, targetName, false);
        return 1;
    }

    private int executeRename(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String sourceName = StringArgumentType.getString(context, (String)"from");
        String targetName = StringArgumentType.getString(context, (String)"to");
        this.copyOrMoveSkin(sender, sourceName, targetName, true);
        return 1;
    }

    private void copyOrMoveSkin(CommandSender sender, String sourceName, String targetName, boolean isMoveOperation) {
        CopyMoveResult result = isMoveOperation ? this.moveSkin(sourceName, targetName) : this.copySkin(sourceName, targetName);
        MessageUtils.send(sender, switch (result.ordinal()) {
            case 0 -> SkinCacheStrings.targetSkinNotFound();
            case 2 -> (isMoveOperation ? SkinCacheStrings.moveSuccess() : SkinCacheStrings.copySuccess()).resolve("source", sourceName).resolve("target", targetName);
            case 1 -> SkinCacheStrings.copyMoveTargetExists();
            default -> new FormattableMessage(this.plugin, "Nil!");
        });
    }

    private CopyMoveResult copySkin(String sourceName, String targetName) {
        GameProfile sourceProfile = this.skinProvider.getCachedProfile(sourceName);
        if (sourceProfile == null) {
            return CopyMoveResult.NO_SUCH_SKIN;
        }
        GameProfile oTarget = this.skinProvider.getCachedProfile(targetName);
        if (oTarget != null) {
            return CopyMoveResult.TARGET_EXISTS;
        }
        GameProfile targetProfile = new GameProfile(sourceProfile.id(), targetName, sourceProfile.properties());
        PlayerProfile profile = CraftPlayerProfile.asBukkitCopy((GameProfile)targetProfile);
        if (profile.getId() == null) {
            this.logger.error("Null profile ID. " + String.valueOf(targetProfile.id()));
            return CopyMoveResult.NO_SUCH_SKIN;
        }
        if (profile.getName() == null) {
            this.logger.error("Null profile Name. " + targetProfile.name());
            return CopyMoveResult.NO_SUCH_SKIN;
        }
        this.skinProvider.cacheProfile(CraftPlayerProfile.asBukkitCopy((GameProfile)targetProfile));
        return CopyMoveResult.SUCCESS;
    }

    private CopyMoveResult moveSkin(String sourceName, String targetName) {
        GameProfile sourceProfile = this.skinProvider.getCachedProfile(sourceName);
        if (sourceProfile == null) {
            return CopyMoveResult.NO_SUCH_SKIN;
        }
        GameProfile oTarget = this.skinProvider.getCachedProfile(targetName);
        if (oTarget != null) {
            return CopyMoveResult.TARGET_EXISTS;
        }
        this.copySkin(sourceName, targetName);
        this.skinProvider.dropSkin(sourceName);
        return CopyMoveResult.SUCCESS;
    }

    @Initializer
    private void load(MorphConfigManager config) {
        config.bind(this.debug, ConfigOptions.DEBUG_OUTPUT);
    }

    private static enum CopyMoveResult {
        NO_SUCH_SKIN,
        TARGET_EXISTS,
        SUCCESS;

    }
}

