/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.request;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.interfaces.IManageRequests;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.HelpStrings;
import xyz.nifeather.morph.messages.strings.RequestStrings;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class SendSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private IManageRequests requests;
    @Resolved
    private MorphManager morphs;

    public int executes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(sender instanceof Player)) {
            return 1;
        }
        Player sourcePlayer = (Player)sender;
        List players = (List)((PlayerSelectorArgumentResolver)context.getArgument("who", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
        players.forEach(targetPlayer -> {
            if (targetPlayer.getUniqueId().equals(sourcePlayer.getUniqueId())) {
                MessageUtils.send(sender, RequestStrings.cantSendToSelfString());
                return;
            }
            String id = DisguiseTypes.PLAYER.toId(targetPlayer.getName());
            if (this.morphs.getAvailableDisguisesFor(sourcePlayer).stream().anyMatch(c -> c.rawIdentifier.equals(id))) {
                MessageUtils.send(sender, RequestStrings.alreadyHaveDisguiseString());
                return;
            }
            this.requests.createRequest(sourcePlayer, (Player)targetPlayer);
        });
        return 1;
    }

    @Override
    public String name() {
        return "send";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.requestSendDescription();
    }
}

