/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.config;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.lang3.RandomStringUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommonStrings;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.BindableList;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigNode;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigOption;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.PluginConfigManager;
import xyz.nifeather.morph.shaded.pluginbase.Managers.DependencyManager;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;

public class MorphConfigManager
extends PluginConfigManager {
    private static MorphConfigManager instance;
    private final Map<String, ConfigOption<?>> options = new ConcurrentHashMap();
    private Map<String, BindableList<?>> bindableLists;
    private final Map<Integer, Consumer<FileConfiguration>> updateMethods = new ConcurrentHashMap<Integer, Consumer<FileConfiguration>>();

    public MorphConfigManager(FeatherMorphMain plugin) {
        super(plugin);
        instance = this;
        Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
        for (Field field : ConfigOptions.class.getFields()) {
            if (field.getType() != ConfigOption.class) continue;
            try {
                ConfigOption val = (ConfigOption)field.get(null);
                logger.debug("Discover field %s --> %s".formatted(field.getName(), val.node()));
                this.options.put(val.node().toString(), val);
            }
            catch (Throwable t) {
                logger.warn("Failed to discover configuration %s, this don't seems right!".formatted(field.getName()), t);
            }
        }
        this.registerUpdateMethods();
    }

    private void registerUpdateMethods() {
        Logger updateLogger = LoggerFactory.getLogger((String)"FeatherMorph$ConfigUpdate");
        this.addUpdateMethod(0, newConfig -> {
            updateLogger.info("#0: Determining language code to use.");
            String locale = Locale.getDefault().toLanguageTag().replace('-', '_').toLowerCase();
            newConfig.set(ConfigOptions.LANGUAGE_CODE.toString(), (Object)locale);
            newConfig.set(ConfigOptions.VERSION.toString(), (Object)1);
        });
        this.addUpdateMethod(14, newConfig -> {
            updateLogger.info("#14: Checking for old action item key.");
            String oldSkillItem = this.get(ConfigOptions.ACTION_ITEM);
            this.remove(ConfigOptions.ACTION_ITEM);
            if (oldSkillItem != null) {
                newConfig.set(ConfigOptions.SKILL_ITEM.toString(), (Object)oldSkillItem);
            }
        });
        this.addUpdateMethod(20, newConfig -> {
            boolean requireCache;
            updateLogger.info("#20: ChatOverride configuration is now in config.yml.");
            DependencyManager depMgr = DependencyManager.getInstance(this.plugin.getNamespace());
            MessageStore messageStore = depMgr.get(MessageStore.class);
            boolean bl = requireCache = depMgr.get(this.getClass(), false) == null;
            if (requireCache) {
                depMgr.cache(this);
            }
            String msg = messageStore.get(CommonStrings.chatOverrideDefaultPattern().getKey(), ConfigOptions.CHAT_OVERRIDE_DEFAULT_PATTERN.getDefault(), MessageUtils.getServerLocale());
            newConfig.set(ConfigOptions.CHAT_OVERRIDE_DEFAULT_PATTERN.toString(), (Object)msg);
            String pluginPrefix = messageStore.get(CommonStrings.pluginMessageString().getKey(), ConfigOptions.PLUGIN_PREFIX.getDefault(), MessageUtils.getServerLocale());
            newConfig.set(ConfigOptions.PLUGIN_PREFIX.toString(), (Object)pluginPrefix);
            if (requireCache) {
                depMgr.unCache(this);
            }
        });
        this.addUpdateMethod(22, newConfig -> {
            updateLogger.info("#22: The old *Modify bounding boxes* config has moved to a new section");
            Boolean val = this.getOrDefault(ConfigOptions.MODIFY_BOUNDING_BOX_LEGACY, null);
            this.remove(ConfigOptions.MODIFY_BOUNDING_BOX_LEGACY);
            if (val != null) {
                newConfig.set(ConfigOptions.MODIFY_BOUNDING_BOX.toString(), (Object)val);
            }
        });
        this.addUpdateMethod(33, newConfig -> {
            updateLogger.info("#33: Flying in water/lava has been changed from no_fly_in_liquid -> disallow_in_water/disallow_in_lava.");
            Boolean noFlyInLiquid = this.getOrDefault(ConfigOptions.FLYABILITY_NO_LIQUID, false);
            this.remove(ConfigOptions.FLYABILITY_NO_LIQUID);
            if (noFlyInLiquid.booleanValue()) {
                List<String> list = Bukkit.getWorlds().stream().map(WorldInfo::getName).toList();
                newConfig.set(ConfigOptions.FLYABILITY_DISALLOW_FLY_IN_WATER.toString(), list);
                newConfig.set(ConfigOptions.FLYABILITY_DISALLOW_FLY_IN_LAVA.toString(), list);
            }
        });
        this.addUpdateMethod(36, newConfig -> {
            updateLogger.info("#36: Removing old skill item config.");
            this.remove(ConfigOptions.SKILL_ITEM);
        });
        this.addUpdateMethod(39, newConfig -> {
            updateLogger.info("#39: Remove the 'show_player_disguises_in_tab' and 'hide_disguised_players_in_tab' options.");
            this.remove(ConfigOptions.SR_SHOW_PLAYER_DISGUISES_IN_TAB);
            this.remove(ConfigOptions.HIDE_DISGUISED_PLAYERS_IN_TAB);
        });
        this.addUpdateMethod(40, newConfig -> {
            updateLogger.info("#40: The sentry logger has been removed since it's not working right, and I don't like to bother about it as we lose 2 follows because of adding it D:");
            this.remove(ConfigOptions.ENABLE_SENTRY_LOGGER);
        });
        this.addUpdateMethod(43, newConfig -> {
            updateLogger.info("#43: Blacklist patterns and tags have been removed as they are no longer being used.");
            this.remove(ConfigOptions.BLACKLIST_PATTERNS);
            this.remove(ConfigOptions.BLACKLIST_TAGS);
        });
    }

    public static MorphConfigManager getInstance() {
        return instance;
    }

    @Override
    @NotNull
    public Map<ConfigNode, Object> getAllNotDefault() {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (ConfigOption<?> o : this.options.values()) {
            Object val = this.getOrDefault(o);
            if (val.equals(o.getDefault())) continue;
            map.put((Object)o.node(), val);
        }
        return map;
    }

    public <T> BindableList<T> getBindableStringList(ConfigOption<List<T>> option) {
        this.ensureBindableListNotNull();
        BindableList val = this.bindableLists.getOrDefault(option.toString(), null);
        if (val != null) {
            return val;
        }
        List originalList = this.backendConfig.getList(option.toString(), new ArrayList());
        originalList.removeIf(listVal -> !option.type().isInstance(listVal));
        BindableList list = new BindableList();
        list.addAll(originalList);
        list.onListChanged((diffList, reason) -> {
            this.backendConfig.set(option.toString(), new ArrayList(list));
            this.save();
        }, true);
        this.bindableLists.put(option.toString(), list);
        return list;
    }

    private void ensureBindableListNotNull() {
        if (this.bindableLists == null) {
            this.bindableLists = new Object2ObjectOpenHashMap();
        }
    }

    private void addUpdateMethod(int startingAt, Consumer<FileConfiguration> runnable) {
        this.updateMethods.put(startingAt, runnable);
    }

    public List<Consumer<FileConfiguration>> getUpdateMethods(int startingFrom) {
        return this.updateMethods.entrySet().stream().filter(entry -> (Integer)entry.getKey() >= startingFrom).sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).toList();
    }

    @Override
    public void reload() {
        super.reload();
        this.ensureBindableListNotNull();
        this.bindableLists.forEach((node, list) -> {
            List configList = this.backendConfig.getList(node);
            if (configList == null) {
                return;
            }
            list.clear();
            list.addAllInternal(configList);
        });
        int targetVersion = 45;
        Integer configVersion = this.getOrDefault(ConfigOptions.VERSION);
        if (configVersion < targetVersion) {
            FeatherMorphMain.getInstance().getSLF4JLogger().info("Migrating config from %s to %s".formatted(configVersion, targetVersion));
            Map<ConfigNode, Object> nonDefaults = this.getAllNotDefault();
            this.plugin.saveResource("config.yml", true);
            this.plugin.reloadConfig();
            FileConfiguration newConfig = this.plugin.getConfig();
            nonDefaults.forEach((n, v) -> {
                ConfigOption matching = this.options.getOrDefault(n.toString(), null);
                if (matching == null) {
                    return;
                }
                if (v instanceof Collection) {
                    Collection collection = (Collection)v;
                    Collection defaultVal = null;
                    Object patt0$temp = matching.getDefault();
                    if (patt0$temp instanceof Collection) {
                        Collection c1;
                        defaultVal = c1 = (Collection)patt0$temp;
                    }
                    if (defaultVal != null) {
                        defaultVal.forEach(c -> {
                            if (!collection.contains(c)) {
                                collection.add(c);
                            }
                        });
                    }
                    newConfig.set(n.toString(), v);
                } else {
                    newConfig.set(n.toString(), v);
                }
            });
            this.getUpdateMethods(configVersion).forEach(c -> c.accept(newConfig));
            newConfig.set(ConfigOptions.VERSION.toString(), (Object)targetVersion);
            this.plugin.saveConfig();
            this.reload();
        }
        this.generateIfUnset(ConfigOptions.MASTER_SECRET);
        this.generateIfUnset(ConfigOptions.UUID_RANDOM_BASE);
    }

    private void generateIfUnset(ConfigOption<String> option) {
        if (!this.getOrDefault(option, "~UNSET").equalsIgnoreCase("~UNSET")) {
            return;
        }
        this.set(option, RandomStringUtils.secure().nextAlphabetic(20));
    }

    public void remove(ConfigOption<?> option) {
        this.set(option, null);
        this.backendConfig.set(option.node().toString(), null);
    }

    @Override
    public <T> T get(ConfigOption<T> option) {
        return this.get(option.type(), option.node());
    }
}

