/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events;

import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.api.events.gameplay.PlayerJoinedWithDisguiseEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerMorphEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerUnMorphEvent;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.mirror.ExecutorHub;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;

public class InteractionMirrorProcessor
extends MorphPluginObject
implements Listener {
    public final Bindable<Boolean> allowSimulation = new Bindable<Boolean>(false);
    public final Bindable<Boolean> allowSneak = new Bindable<Boolean>(false);
    public final Bindable<Boolean> allowSwap = new Bindable<Boolean>(false);
    public final Bindable<Boolean> allowDrop = new Bindable<Boolean>(false);
    public final Bindable<Boolean> allowHotBar = new Bindable<Boolean>(false);
    public final Bindable<String> selectionMode = new Bindable<String>("BY_NAME");
    public final Bindable<Boolean> debugOutput = new Bindable<Boolean>(false);
    @Resolved(shouldSolveImmediately=true)
    private ExecutorHub executorHub;

    @Initializer
    private void load(MorphConfigManager config) {
        config.bind(this.allowSimulation, ConfigOptions.MIRROR_BEHAVIOR_DO_SIMULATION);
        config.bind(this.allowSneak, ConfigOptions.MIRROR_BEHAVIOR_SNEAK);
        config.bind(this.allowSwap, ConfigOptions.MIRROR_BEHAVIOR_SWAP_HAND);
        config.bind(this.allowDrop, ConfigOptions.MIRROR_BEHAVIOR_DROP);
        config.bind(this.allowHotBar, ConfigOptions.MIRROR_BEHAVIOR_HOTBAR);
        config.bind(this.selectionMode, ConfigOptions.MIRROR_SELECTION_MODE);
        config.bind(this.debugOutput, ConfigOptions.DEBUG_OUTPUT);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerSneak(PlayerToggleSneakEvent e) {
        if (!this.allowSneak.get().booleanValue()) {
            return;
        }
        this.executorHub.executeIfExists(this.selectionMode.get(), executor -> executor.onSneak(e.getPlayer(), e.isSneaking()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerSwapHand(PlayerSwapHandItemsEvent e) {
        if (!this.allowSwap.get().booleanValue()) {
            return;
        }
        this.executorHub.executeIfExists(this.selectionMode.get(), executor -> executor.onSwapHand(e.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHotbarChange(PlayerItemHeldEvent e) {
        if (!this.allowHotBar.get().booleanValue()) {
            return;
        }
        this.executorHub.executeIfExists(this.selectionMode.get(), executor -> executor.onHotbarChange(e.getPlayer(), e.getNewSlot()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerStopUsingItem(PlayerStopUsingItemEvent e) {
        this.executorHub.executeIfExists(this.selectionMode.get(), executor -> executor.onStopUsingItem(e.getPlayer(), e.getItem()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerHurtEntity(EntityDamageByEntityEvent e) {
        if (!this.allowSimulation.get().booleanValue()) {
            return;
        }
        Entity entity = e.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player damager = (Player)entity;
        Entity entity2 = e.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player hurted = (Player)entity2;
        AtomicBoolean shouldCancel = new AtomicBoolean(false);
        this.executorHub.executeIfExists(this.selectionMode.get(), executor -> shouldCancel.set(executor.onHurtEntity(damager, (LivingEntity)hurted)));
        if (shouldCancel.get()) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerSwing(PlayerArmSwingEvent e) {
        if (!this.allowSimulation.get().booleanValue()) {
            return;
        }
        AtomicBoolean shouldCancel = new AtomicBoolean(false);
        this.executorHub.executeIfExists(this.selectionMode.get(), executor -> shouldCancel.set(executor.onSwing(e.getPlayer())));
        if (shouldCancel.get()) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!this.allowSimulation.get().booleanValue()) {
            return;
        }
        this.executorHub.executeIfExists(this.selectionMode.get(), executor -> executor.onInteract(e.getPlayer(), e.getAction()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent e) {
        if (!this.allowSimulation.get().booleanValue()) {
            return;
        }
        this.executorHub.executeIfExists(this.selectionMode.get(), executor -> executor.onInteract(e.getPlayer(), Action.RIGHT_CLICK_AIR));
    }

    @EventHandler
    public void onPlayerExit(PlayerQuitEvent e) {
        this.executorHub.unregisterControl(e.getPlayer());
    }

    @EventHandler
    public void onPlayerMorph(PlayerMorphEvent e) {
        this.addOrRemoveFromMirrorMap(e.state, e.getPlayer());
    }

    @EventHandler
    public void onPlayerUnMorph(PlayerUnMorphEvent e) {
        this.executorHub.unregisterControl(e.getPlayer());
    }

    @EventHandler
    public void onJoinedWithState(PlayerJoinedWithDisguiseEvent e) {
        this.addOrRemoveFromMirrorMap(e.state, e.getPlayer());
    }

    private void addOrRemoveFromMirrorMap(DisguiseState state, Player player) {
        String id = state.getDisguiseIdentifier();
        if (DisguiseTypes.fromId(id) == DisguiseTypes.PLAYER) {
            this.executorHub.registerControl(player, DisguiseTypes.PLAYER.toStrippedId(id));
        } else {
            this.executorHub.unregisterControl(player);
        }
    }

    public static class InteractionMirrorSelectionMode {
        public static final String BY_NAME = "BY_NAME";
        public static final String BY_SIGHT = "BY_SIGHT";
        public static final String BY_RANGE = "BY_RANGE";

        public static List<String> values() {
            return List.of(BY_NAME, BY_SIGHT, BY_RANGE);
        }

        public static List<String> valuesLowerCase() {
            return InteractionMirrorSelectionMode.values().stream().map(String::toLowerCase).toList();
        }
    }
}

