/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.messages;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.utilities.PluginAssetUtils;

public class OverlayingMessageStore {
    private final String targetLocale;
    protected final Logger logger;
    protected final FeatherMorphMain plugin;
    protected final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    protected final Map<String, String> i18nMap = new ConcurrentHashMap<String, String>();

    public String targetLocale() {
        return this.targetLocale;
    }

    public OverlayingMessageStore(String targetLocale) {
        this.targetLocale = targetLocale;
        this.plugin = FeatherMorphMain.getInstance();
        this.logger = FeatherMorphMain.getInstance().getSLF4JLogger();
    }

    public Optional<String> lookup(String messageKey) {
        return Optional.ofNullable(this.i18nMap.getOrDefault(messageKey, null));
    }

    public void load() {
        this.loadFromPluginAsset();
        File messagesDirectory = new File(this.plugin.getDataFolder(), "messages");
        File languageFileOnDisk = new File(messagesDirectory, "%s.json".formatted(this.targetLocale));
        if (languageFileOnDisk.exists()) {
            this.loadFromFileSystem(languageFileOnDisk);
        } else if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
            this.logger.info("Skipping Override File for '%s' because '%s' not exist".formatted(this.targetLocale, languageFileOnDisk.getAbsolutePath()));
        }
    }

    private void loadFromFileSystem(File i18nFile) {
        try {
            String str = Files.readString(i18nFile.toPath());
            Map fileI18nMap = (Map)this.gson.fromJson(str, (TypeToken)new TypeToken<Map<String, String>>(this){});
            if (fileI18nMap == null) {
                return;
            }
            this.i18nMap.putAll(fileI18nMap);
        }
        catch (Exception e) {
            this.logger.error("Unable to read i18n for language '%s' from file %s on disk".formatted(this.targetLocale, i18nFile.getName()), (Throwable)e);
        }
    }

    public void clear() {
        this.i18nMap.clear();
    }

    public void reload() {
        this.clear();
        this.load();
    }

    public boolean isEmpty() {
        return this.i18nMap.isEmpty();
    }

    private void loadFromPluginAsset() {
        String path = PluginAssetUtils.langPath(this.targetLocale);
        Optional<String> asset = PluginAssetUtils.getFileStringsOptional(path);
        if (asset.isEmpty()) {
            if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
                this.logger.info("Skipping %s from plugin assets because it doesn't exists".formatted(this.targetLocale));
            }
            return;
        }
        Type typeToken = new TypeToken<Map<String, String>>(this){}.getType();
        try {
            Map assetI18n = (Map)this.gson.fromJson(asset.get(), typeToken);
            this.i18nMap.putAll(assetI18n);
        }
        catch (Exception e) {
            this.logger.error("Unable to read i18n for language '%s' from plugin assets".formatted(this.targetLocale), (Throwable)e);
        }
    }
}

